<!DOCTYPE html>
<html lang="<?php echo current_language(); ?>" dir="<?php echo text_direction(); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="<?php echo config('app.ui.primary_color'); ?>">
    <meta name="description" content="Comprehensive security company management platform">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="<?php echo config('app.acronym'); ?>">
    <title><?php echo e($pageTitle ?? config('app.name') . ' - ' . config('app.company')); ?></title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '<?php echo config('app.ui.primary_color'); ?>'
                    }
                }
            }
        }
    </script>
    
    <!-- Google Fonts - PT Sans Narrow -->
    <link href="https://fonts.googleapis.com/css2?family=PT+Sans+Narrow:wght@400;700&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo config('app.url'); ?>/css/main.css">
    
    <!-- Animate.js -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    
    <!-- SweetAlert2 for toast notifications -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Chart.js for data visualization -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Quill Rich Text Editor -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    
    <!-- Draft Manager -->
    <script src="<?php echo config('app.url'); ?>/js/draft-manager.js"></script>
    
    <!-- PWA Manifest - Use absolute path for better mobile support -->
    <link rel="manifest" href="/manifest.json">
    <link rel="icon" type="image/png" href="<?php echo config('app.ui.site_logo'); ?>">
    <link rel="apple-touch-icon" href="<?php echo config('app.ui.site_logo'); ?>"
    
    <style>
        * {
            font-family: 'PT Sans Narrow', sans-serif;
        }
        
        :root {
            --primary-color: <?php echo config('app.ui.primary_color'); ?>;
        }
        
        /* Sidebar collapse animation */
        .sidebar {
            transition: width 0.3s ease;
        }
        
        .sidebar.collapsed {
            width: 80px;
        }
        
        .sidebar-label {
            transition: opacity 0.3s ease;
        }
        
        .sidebar.collapsed .sidebar-label {
            display: none;
        }
      
    </style>
    
    <?php if(isset($additionalCSS)): ?>
        <?php foreach($additionalCSS as $css): ?>
            <link rel="stylesheet" href="<?php echo $css; ?>">
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body class="overflow-x-hidden" style="--primary-color: <?php echo config('app.ui.primary_color') ?? '#2563eb'; ?>;">
    <!-- Offline Banner -->
    <div id="offlineBanner" class="hidden fixed top-0 left-0 right-0 bg-red-600 text-white px-4 py-3 shadow-lg z-[100] flex items-center justify-between animate-pulse">
        <div class="flex items-center gap-3 max-w-full flex-1">
            <i class="fas fa-wifi-slash text-lg flex-shrink-0"></i>
            <div class="min-w-0">
                <p class="font-semibold text-sm sm:text-base">You are offline</p>
                <p class="text-xs sm:text-sm opacity-90">Last synced: <span id="lastSyncTime">now</span></p>
            </div>
        </div>
        <button onclick="document.getElementById('offlineBanner').classList.add('hidden')" class="flex-shrink-0 ml-2 hover:bg-red-700 px-2 py-1 rounded">
            <i class="fas fa-times"></i>
        </button>
    </div>

    <!-- Online Indicator -->
    <div id="onlineIndicator" class="hidden fixed bottom-4 right-4 bg-green-600 text-white px-4 py-2 rounded-lg shadow-lg z-50 flex items-center gap-2 animate-fade-in">
        <i class="fas fa-check-circle"></i>
        <span class="text-sm">Back online</span>
    </div>
    
    <?php 
    $primaryColor = config('app.ui.primary_color') ?? '#2563eb';
    if($auth->isAuthenticated()): ?>
        <!-- Header -->
        <header style="background: linear-gradient(135deg, <?php echo htmlspecialchars($primaryColor); ?> 0%, <?php echo htmlspecialchars($primaryColor); ?> 100%);" class="text-white shadow-md sticky top-0 z-50">
            <nav class="max-w-full mx-auto px-4 sm:px-6 py-3 sm:py-4 flex justify-between items-center">
                <!-- Logo Section -->
                <div class="flex items-center space-x-2 sm:space-x-3">
                    <img src="<?php echo config('app.ui.site_logo'); ?>" alt="Logo" class="h-8 sm:h-10 w-auto">
                    <div class="hidden sm:block">
                        <h1 class="text-lg sm:text-xl font-bold text-white"><?php echo config('app.acronym'); ?></h1>
                        <p class="text-xs text-white/80"><?php echo trans('system_name') ?? config('app.name'); ?></p>
                    </div>
                </div>
                
                <!-- Header Actions -->
                <div class="flex items-center space-x-4 md:space-x-6">
                    <!-- Language Switcher -->
                    <div class="relative group">
                        <button id="languageBtn" class="flex items-center space-x-1 md:space-x-2 text-white/90 hover:text-white cursor-pointer transition-colors px-3 py-2 rounded-lg hover:bg-white/20">
                            <i class="fas fa-globe text-base"></i>
                            <span class="hidden lg:inline text-sm font-medium"><?php echo current_language() === 'en' ? trans('english') : trans('french'); ?></span>
                            <i class="fas fa-chevron-down text-xs hidden lg:inline"></i>
                        </button>
                        <div id="languageMenu" class="hidden absolute right-0 mt-1 w-48 bg-white rounded-lg shadow-lg border border-gray-100 z-50 overflow-hidden">
                            <?php 
                            $currentUrl = strtok($_SERVER['REQUEST_URI'], '?');
                            $query = $_SERVER['QUERY_STRING'] ? '?' . $_SERVER['QUERY_STRING'] : '';
                            $langUrl = preg_replace('/([&?])lang=[^&]*/', '', $query);
                            $langUrl = preg_replace('/^\?&/', '?', $langUrl);
                            $langUrl = $langUrl === '?' ? '' : $langUrl;
                            ?>
                            <a href="<?php echo $currentUrl . $langUrl . ($langUrl ? '&' : '?'); ?>lang=en" class="flex items-center space-x-3 px-4 py-3 text-gray-700 hover:bg-blue-50 transition-colors border-b border-gray-100">
                                <span class="text-lg">🇬🇧</span>
                                <span class="text-sm"><?php echo trans('english'); ?></span>
                            </a>
                            <a href="<?php echo $currentUrl . $langUrl . ($langUrl ? '&' : '?'); ?>lang=fr" class="flex items-center space-x-3 px-4 py-3 text-gray-700 hover:bg-blue-50 transition-colors">
                                <span class="text-lg">🇫🇷</span>
                                <span class="text-sm"><?php echo trans('french'); ?></span>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Notifications -->
                    <div class="relative group">
                        <button id="notificationBtn" class="relative text-white/90 hover:text-white cursor-pointer transition-colors px-3 py-2 rounded-lg hover:bg-white/20">
                            <i class="fas fa-bell text-lg"></i>
                            <span id="notificationBadge" class="absolute top-1 right-1 bg-red-500 text-white text-xs font-bold rounded-full h-5 w-5 flex items-center justify-center hidden animate-pulse">0</span>
                        </button>
                        <div id="notificationPanel" class="hidden absolute right-0 mt-1 w-96 bg-white rounded-lg shadow-xl border border-gray-100 z-50 max-h-96 overflow-hidden flex flex-col">
                            <div class="p-4 border-b border-gray-200 flex justify-between items-center" style="background-color: <?php echo htmlspecialchars($primaryColor); ?>20;">
                                <h3 class="font-semibold text-gray-800"><?php echo trans('notifications'); ?></h3>
                                <button id="markAllRead" class="text-xs font-semibold hover:underline" style="color: <?php echo htmlspecialchars($primaryColor); ?>;"><?php echo trans('mark_all_read'); ?></button>
                            </div>
                            <div id="notificationList" class="flex-1 overflow-y-auto"></div>
                            <div class="p-4 border-t border-gray-200 text-center" style="background-color: <?php echo htmlspecialchars($primaryColor); ?>10;">
                                <a href="?page=messages" class="text-sm font-semibold hover:underline" style="color: <?php echo htmlspecialchars($primaryColor); ?>;"><?php echo trans('view_all'); ?></a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- User Menu -->
                    <div class="relative group">
                        <button id="userMenuBtn" class="flex items-center space-x-2 text-white/90 hover:text-white cursor-pointer transition-colors px-2 py-1 rounded-lg hover:bg-white/20">
                            <?php if ($auth->getCurrentUser()['photo']): ?>
                                <img src="<?php echo e($auth->getCurrentUser()['photo']); ?>" alt="Profile" class="h-8 w-8 rounded-full object-cover border-2 border-white/30">
                            <?php else: ?>
                                <i class="fas fa-user-circle text-2xl text-white/60"></i>
                            <?php endif; ?>
                            <span class="hidden md:inline text-sm font-medium max-w-[150px] truncate"><?php echo e($auth->getCurrentUser()['name'] ?? trans('user')); ?></span>
                            <i class="fas fa-chevron-down text-xs hidden md:inline text-white/60"></i>
                        </button>
                        <div id="userMenu" class="hidden absolute right-0 mt-1 w-56 bg-white rounded-lg shadow-lg border border-gray-100 z-50 overflow-hidden">
                            <div class="px-4 py-3 border-b border-gray-100 bg-gray-50">
                                <p class="text-sm font-semibold text-gray-800"><?php echo e($auth->getCurrentUser()['name'] ?? trans('user')); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($auth->getCurrentUser()['email'] ?? ''); ?></p>
                            </div>
                            <a href="?page=profile" class="flex items-center space-x-3 px-4 py-3 text-gray-700 hover:bg-blue-50 transition-colors border-b border-gray-100">
                                <i class="fas fa-user text-blue-600 w-5"></i>
                                <span class="text-sm"><?php echo trans('profile'); ?></span>
                            </a>
                            <?php if ($_SESSION['role'] === 'admin'): ?>
                            <a href="?page=settings" class="flex items-center space-x-3 px-4 py-3 text-gray-700 hover:bg-blue-50 transition-colors border-b border-gray-100">
                                <i class="fas fa-cog text-blue-600 w-5"></i>
                                <span class="text-sm"><?php echo trans('settings'); ?></span>
                            </a>
                            <?php endif; ?>
                            <a href="?action=logout" class="flex items-center space-x-3 px-4 py-3 text-red-600 hover:bg-red-50 transition-colors">
                                <i class="fas fa-sign-out-alt text-red-600 w-5"></i>
                                <span class="text-sm"><?php echo trans('logout'); ?></span>
                            </a>
                        </div>
                    </div>
                </div>
            </nav>
        </header>
        
        <!-- Sidebar Navigation - Hidden on Mobile -->
        <div class="flex">
            <aside id="sidebar" class="hidden md:block sidebar w-64 bg-white shadow h-screen sticky top-16 overflow-y-auto">
                <div class="p-4">
                    <button id="sidebarToggle" class="w-full text-left p-2 rounded hover:bg-gray-100 mb-4">
                        <i class="fas fa-bars text-lg"></i>
                    </button>
                </div>
                <nav class="p-4 space-y-2">
                    <?php
                    $userRole = $_SESSION['role'] ?? null;
                    
                    // Different menu based on user role
                    if ($userRole === 'client') {
                        $pages = [
                            'clients/dashboard' => ['icon' => 'fa-chart-line', 'label' => 'my_dashboard'],
                            'clients/profile' => ['icon' => 'fa-user-circle', 'label' => 'profile'],
                            'clients/my-posts' => ['icon' => 'fa-file-contract', 'label' => 'my_posts'],
                            'clients/contract' => ['icon' => 'fa-handshake', 'label' => 'contract'],
                            'clients/site-assessment' => ['icon' => 'fa-clipboard-list', 'label' => 'assessment'],
                            'clients/my-guards' => ['icon' => 'fa-people-group', 'label' => 'my_guards'],
                            'clients/my-controls' => ['icon' => 'fa-list-check', 'label' => 'my_controls'],
                            'clients/my-feedbacks' => ['icon' => 'fa-star', 'label' => 'feedbacks'],
                            'clients/my-patrols' => ['icon' => 'fa-map-location-dot', 'label' => 'patrols'],
                            'clients/my-invoices' => ['icon' => 'fa-file-invoice-dollar', 'label' => 'my_invoices'],
                            'clients/payments' => ['icon' => 'fa-credit-card', 'label' => 'payments'],
                            'clients/messages' => ['icon' => 'fa-envelope', 'label' => 'messages'],
                        ];
                    } elseif ($userRole === 'guard') {
                        $pages = [
                            'guards-dashboard' => ['icon' => 'fa-chart-line', 'label' => 'my_dashboard'],
                            'guards-profile' => ['icon' => 'fa-user-circle', 'label' => 'profile'],
                            'guards-posts' => ['icon' => 'fa-map-pin', 'label' => 'my_post'],
                            'guards-patrols' => ['icon' => 'fa-map-location-dot', 'label' => 'my_patrols'],
                            'guards-controls' => ['icon' => 'fa-list-check', 'label' => 'my_controls'],
                            'guards-payments' => ['icon' => 'fa-credit-card', 'label' => 'my_payments'],
                            'guards-messages' => ['icon' => 'fa-envelope', 'label' => 'messages'],
                        ];
                    } elseif ($userRole === 'controller') {
                        $pages = [
                            'controllers-dashboard' => ['icon' => 'fa-chart-line', 'label' => 'my_dashboard'],
                            'controllers-profile' => ['icon' => 'fa-user-circle', 'label' => 'profile'],
                            'controllers-posts' => ['icon' => 'fa-map-pin', 'label' => 'posts_in_zone'],
                            'controllers-patrols' => ['icon' => 'fa-map-location-dot', 'label' => 'patrols'],
                            'controllers-controls' => ['icon' => 'fa-list-check', 'label' => 'controls'],
                            'controllers-payments' => ['icon' => 'fa-credit-card', 'label' => 'my_payments'],
                            'controllers-messages' => ['icon' => 'fa-envelope', 'label' => 'messages'],
                        ];
                    } else {
                        $pages = [
                            'dashboard' => ['icon' => 'fa-home', 'label' => 'dashboard'],
                            'clients' => ['icon' => 'fa-users', 'label' => 'clients'],
                            'staff' => ['icon' => 'fa-people-group', 'label' => 'staff'],
                            'posts' => ['icon' => 'fa-map-pin', 'label' => 'posts'],
                            'guards' => ['icon' => 'fa-shield', 'label' => 'guards'],
                            'patrols' => ['icon' => 'fa-route', 'label' => 'patrols'],
                            'invoices' => ['icon' => 'fa-file-invoice-dollar', 'label' => 'invoices'],
                            'payments' => ['icon' => 'fa-credit-card', 'label' => 'payments'],
                            'salaries' => ['icon' => 'fa-money-check', 'label' => 'salaries'],
                            'finances' => ['icon' => 'fa-money-bill', 'label' => 'finances'],
                            'controls' => ['icon' => 'fa-list-check', 'label' => 'controls'],
                            'messages' => ['icon' => 'fa-envelope', 'label' => 'messages'],
                            'feedbacks' => ['icon' => 'fa-star', 'label' => 'feedbacks'],
                            'evaluations' => ['icon' => 'fa-star', 'label' => 'evaluations'],
                            'roles' => ['icon' => 'fa-users-cog', 'label' => 'user_management'],
                            'settings' => ['icon' => 'fa-gear', 'label' => 'settings'],
                        ];
                    }
                    
                    foreach($pages as $pageName => $pageInfo):
                        if($auth->canAccessPage($pageName)):
                            $isActive = ($_GET['page'] ?? 'dashboard') === $pageName;
                    ?>
                    <a href="?page=<?php echo $pageName; ?>" 
                       class="flex items-center space-x-3 px-4 py-2 rounded transition-all <?php echo $isActive ? 'bg-blue-100 text-blue-600 font-bold' : 'text-gray-700 hover:bg-gray-100'; ?>"
                       title="<?php echo trans($pageInfo['label']); ?>">
                        <i class="fas <?php echo $pageInfo['icon']; ?> w-6 text-center flex-shrink-0"></i>
                        <span class="sidebar-label"><?php echo trans($pageInfo['label']); ?></span>
                    </a>
                    <?php
                        endif;
                    endforeach;
                    ?>
                </nav>
            </aside>
            
            <!-- Main Content -->
            <main class="flex-1 p-2 w-full md:p-6 pb-24 md:pb-32">
                <div class="max-w-7xl mx-auto overflow-x-hidden">
    <?php else: ?>
        <!-- Non-authenticated layout (Auth pages) -->
        <!DOCTYPE html>
        <html lang="<?php echo current_language(); ?>" dir="<?php echo text_direction(); ?>">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title><?php echo $pageTitle ?? config('app.name'); ?></title>
            
            <script src="https://cdn.tailwindcss.com"></script>
            <link href="https://fonts.googleapis.com/css2?family=PT+Sans+Narrow:wght@400;700&display=swap" rel="stylesheet">
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
            <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
            
            <style>
                * {
                    font-family: 'PT Sans Narrow', sans-serif;
                }
            </style>
        </head>
        <body class="bg-gradient-to-br from-blue-600 to-blue-800 min-h-screen flex items-center justify-center">
            <div class="w-full max-w-md">
    <?php endif; ?>
