<?php
/**
 * Staff Employee Badge
 * Printable ID card with photo and QR code
 */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($staff['employee_name']); ?> - Employee Badge</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            background: #f5f5f5;
            /* padding: 20px;
            display: flex; */
            justify-content: center;
            align-items: center;
line-height: 1;        }

        .badge-container {
            width: 350px;
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
            position: relative;
            max-height: 610px;
        }

        /* Header with company colors */
        .badge-header {
            background: linear-gradient(135deg, #D2691E 0%, #A0522D 100%);
            color: white;
            padding: 20px;
            text-align: center;
        }

        .company-name {
            font-size: 18px;
            font-weight: bold;
            letter-spacing: 2px;
            margin-bottom: 5px;
        }

        .badge-title {
            font-size: 12px;
            opacity: 0.9;
            font-weight: 500;
        }

        /* Photo section */
        .photo-section {
            padding: 15px;
            text-align: center;
            border-bottom: 2px solid #f0f0f0;
        }

        .employee-photo {
            width: 120px;
            height: 120px;
            border: 3px solid #c1c1c1ff;
            border-radius: 8px;
            object-fit: cover;
            margin: 0 auto 15px;
            display: block;
            background: #f5f5f5;
        }

        .no-photo {
            width: 120px;
            height: 120px;
            border: 3px solid #c1c1c1ff;
            border-radius: 8px;
            margin: 0 auto 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
            font-size: 48px;
            color: #474b55ff;
        }

        /* Employee info */
        .info-section {
            padding: 10px;
            text-align: center;
        }

        .employee-name {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 5px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .employee-position {
            font-size: 14px;
            color: #2563eb;
            font-weight: 600;
            margin-bottom: 10px;
        }

        .employee-details {
            font-size: 12px;
            color: #374151;
            line-height: 1.6;
            margin-bottom: 15px;
        }

        .detail-row {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 8px;
            margin-bottom: 5px;
        }

        .detail-icon {
            color: #2563eb;
            width: 16px;
        }

        /* QR Code section */
        .qr-section {
            padding: 15px;
            text-align: center;
            border-top: 2px solid #f0f0f0;
            background: #fafafa;
        }

        .qr-label {
            font-size: 10px;
            color: #999;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
        }

        .qr-code {
            display: inline-block;
            padding: 5px;
            background: white;
            border: 1px solid #ddd;
            border-radius: 4px;
        }

        .qr-code img {
            display: block;
            width: 80px;
            height: 80px;
        }

        /* Footer */
        .badge-footer {
            padding: 10px 20px;
            background: #f0f0f0;
            text-align: center;
            font-size: 10px;
            color: #999;
            border-top: 1px solid #ddd;
        }

        .staff-id-display {
            font-weight: bold;
            color: #2563eb;
            letter-spacing: 1px;
        }

        /* Print styles */
        @media print {
            body {
                background: white;
                padding: 0;
            }

            .badge-container {
                box-shadow: none;
                border: 1px solid #ddd;
                width: 100%;
                margin: 0;
            }

            /* Print as A6 (105mm x 148mm) or smaller */
            @page {
                size: A6;
                margin: 0;
            }
        }

        /* Responsive */
        @media (max-width: 600px) {
            .badge-container {
                width: 100%;
                max-width: 350px;
            }
        }
    </style>
</head>
<body>
    <div class="print-button" style="position: absolute; top: 10px; right: 10px;">
        <button onclick="printBadge()" style="padding: 8px 12px; font-size: 12px; cursor: pointer;">Print Badge</button>
    </div>
    <div class="badge_area" style="padding: 40px;">
    <div class="badge-container">
        <!-- Header -->
        <div class="badge-header">
            <div class="company-name">SHEPHERD SECURITY AND CONSULTANCY INTERNATIONAL</div>
            <div class="badge-title">EMPLOYEE IDENTIFICATION BADGE</div>
        </div>

        <!-- Photo Section -->
        <div class="photo-section">
            <?php if (!empty($staff['photo_url'])): ?>
                <img src="<?php echo htmlspecialchars($staff['photo_url']); ?>" alt="<?php echo htmlspecialchars($staff['employee_name']); ?>" class="employee-photo">
            <?php else: ?>
                <div class="no-photo">
                    <i class="fas fa-user"></i>
                </div>
            <?php endif; ?>
        </div>

        <!-- Employee Information -->
        <div class="info-section">
            <div class="employee-name"><?php echo htmlspecialchars($staff['employee_name']); ?></div>
            <div class="employee-position"><?php echo htmlspecialchars($staff['position']); ?></div>

            <div class="employee-details">
                <div class="detail-row">
                    <span class="detail-icon">ID:</span>
                    <span class="staff-id-display"><?php echo htmlspecialchars($staff['staff_id']); ?></span>
                </div>
                <?php if (!empty($staff['zone'])): ?>
                    <div class="detail-row">
                        <span class="detail-icon">📍</span>
                        <span><?php echo htmlspecialchars($staff['zone']); ?></span>
                    </div>
                <?php endif; ?>
                <div class="detail-row">
                    <span class="detail-icon">📧</span>
                    <span><?php echo htmlspecialchars($staff['email'] ?? '-'); ?></span>
                </div>
                <?php if (!empty($staff['phone'])): ?>
                    <div class="detail-row">
                        <span class="detail-icon">📱</span>
                        <span><?php echo htmlspecialchars($staff['phone']); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- QR Code -->
        <div class="qr-section">
            <div class="qr-label">Verification Code</div>
            <div class="qr-code">
                <img src="<?php echo htmlspecialchars($qr_url); ?>" alt="QR Code">
            </div>
        </div>

        <!-- Footer -->
        <div class="badge-footer">
            <span class="staff-id-display"><?php echo htmlspecialchars($staff['staff_id']); ?></span>
            <span> • </span>
            <span><?php echo date('M d, Y'); ?></span>
        </div>
    </div>
</div>
    <script>
        // Auto-print functionality (optional - can be triggered by user)
        window.addEventListener('load', function() {
            // Uncomment the line below to auto-print:
            // window.print();
        });

        // Print button functionality
        function printBadge() {
            window.print();
        }
    </script>

<? include_once __DIR__ . '/../layout/footer.php'; ?>
