<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Employee Contract - <?= htmlspecialchars($contract_number ?? '') ?></title>

<!-- Google font -->
<link href="https://fonts.googleapis.com/css2?family=PT+Sans+Narrow:wght@400;700&display=swap" rel="stylesheet">

<style>
    :root {
        --primary-color: #D2691E;
        --accent-dark: #1f2937;
        --muted: #6b7280;
        --page-width: 800px;
    }

    html, body { font-family: 'PT Sans Narrow', Arial, sans-serif; color: #111827; margin: 0; padding: 0; -webkit-print-color-adjust: exact; }
    .page { width: var(--page-width); margin: 24px auto; padding: 28px 36px; box-sizing: border-box; background: #fff; color: #111; }
    header2 { display:flex; align-items:center; justify-content:space-between; border-bottom:6px solid var(--primary-color); padding-bottom:12px; margin-bottom:18px; }
    .brand { display:flex; gap:14px; align-items:center; }
    .brand .logo { width:72px; height:72px; border-radius:8px; background:#f3f4f6; display:flex;align-items:center;justify-content:center; font-weight:700; color:var(--primary-color); border:2px solid rgba(0,0,0,0.04); }
    .brand h1 { font-size:20px; margin:0; color:var(--accent-dark); }
    .meta { text-align:right; font-size:12px; color:var(--muted) }
    .title { margin:18px 0 6px 0; color:var(--accent-dark); font-size:18px; font-weight:700; text-align:center; }
    .sub { text-align:center; color:var(--muted); margin-bottom:18px; font-size:13px; }

    .section { margin:12px 0 20px 0; line-height:1.45; font-size:13px; }
    .section h3 { color:var(--primary-color); margin:0 0 6px 0; font-size:14px; }
    .clause { margin:8px 0; }
    .clause p { margin:4px 0; text-indent:18px; }

    ol.terms { margin:8px 0 0 18px; padding:0; }
    ol.terms > li { margin:10px 0; }
    ol.subterms { margin:6px 0 0 20px; }

    table { width:100%; border-collapse:collapse; margin:10px 0; font-size:13px; }
    table th, table td { border:1px solid #e5e7eb; padding:8px 10px; text-align:left; vertical-align:top; }
    table th { background:linear-gradient(180deg,var(--primary-color),rgba(0,0,0,0.02)); color:#fff; font-weight:700; }
    .price { text-align:right; }

    .sign-blocks { display:flex; gap:20px; margin-top:28px; }
    .sign { flex:1; border-top:1px solid #e5e7eb; padding-top:8px; text-align:left; font-size:13px; }
    .small { font-size:12px; color:var(--muted); }

    footer { margin-top:30px; border-top:1px dashed #e5e7eb; padding-top:10px; font-size:12px; color:var(--muted); display:flex; justify-content:space-between; }

    /* printing */
    @media print {
        body { background: #fff; }
        .page { box-shadow:none; margin:0; }
    }
</style>
</head>
<body>
<div class="page">
    <header2>
        <div class="brand">
            <div class="logo">SSCI</div>
            <div>
                <h1>SHEPHERD SECURITY AND CONSULTANCY INTERNATIONAL</h1>
                <div class="small">Opposite PCSS Buea Town, P.O.Box 554, Buea</div>
            </div>
        </div>

        <div class="meta">
            <div>Document: <strong>Employee Contract</strong></div>
            <div>Contract No: <strong><?= htmlspecialchars($contract_number ?? '') ?></strong></div>
            <div>Date: <strong><?= htmlspecialchars($contract_date ?? date('Y-m-d')) ?></strong></div>
        </div>
    </header2>

    <div class="title">EMPLOYEE CONTRACT</div>
    <div class="sub">This contract is made between <strong>SHEPHERD SECURITY AND CONSULTANCY INTERNATIONAL</strong> (the "Employer") and <strong>The Employee</strong>.</div>

    <div class="section">
        <h3>1. Personal Information</h3>
        <div class="clause">
            <p>The Employee is identified as follows:</p>
            <ul>
                <li>Telephone Number: <strong><?= htmlspecialchars($employee_phone ?? '') ?></strong></li>
                <li>Current Residence: <strong><?= htmlspecialchars($employee_residence ?? '') ?></strong></li>
                <li>National ID Card No.: <strong><?= htmlspecialchars($employee_id ?? '') ?></strong></li>
                <li>Issued at: <strong><?= htmlspecialchars($id_issued_at ?? '') ?></strong> on <strong><?= htmlspecialchars($id_issue_date ?? '') ?></strong></li>
            </ul>
        </div>
    </div>

    <div class="section">
        <h3>2. Terms of Employment</h3>
        <div class="clause">
            <p>The Employee shall be recruited in the capacity of <strong><?= htmlspecialchars($job_title ?? '') ?></strong>.</p>
            <p>The Employee shall earn a monthly basic salary of <strong><?= htmlspecialchars($salary ?? '') ?></strong>.</p>
            <p>The Employee is entitled to the following allowances: <strong><?= htmlspecialchars($allowances ?? '') ?></strong></p>
        </div>
    </div>

    <div class="section">
        <h3>3. Contract Duration</h3>
        <div class="clause">
            <p>The contract shall run from <strong><?= htmlspecialchars($contract_start ?? '') ?></strong> to <strong><?= htmlspecialchars($contract_end ?? '') ?></strong>. In the event where termination is not issued by the Employer at the end of the contract, the contract shall be deemed renewed on a monthly basis under the same terms.</p>
        </div>
    </div>

    <div class="section">
        <h3>4. Work Shifts</h3>
        <table>
            <thead>
                <tr><th>Shift</th><th>Starting Time</th><th>Closing Time</th></tr>
            </thead>
            <tbody>
                <tr><td>Day Shift</td><td>06:00 AM</td><td>06:00 PM</td></tr>
                <tr><td>Night Shift</td><td>06:00 PM</td><td>06:00 AM</td></tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <h3>5. Responsibilities of the Employee</h3>
        <ol class="terms">
            <li>Report to work on time</li>
            <li>Keep working materials clean at all times</li>
            <li>Return all company properties as soon as work stops</li>
            <li>Perform duties conscientiously and professionally</li>
            <li>Exhibit discipline and respect for hierarchy</li>
            <li>Maintain a courteous attitude towards the public</li>
            <li>Observe professional secrecy</li>
            <li>Be in uniform at all times</li>
            <li>Be ready to work in shifts without objection</li>
            <li>Report appropriately in log books</li>
        </ol>
    </div>

    <div class="section">
        <h3>6. Prohibited Actions</h3>
        <ol class="terms">
            <li>Enter the establishment in a state of drunkenness</li>
            <li>Sleep or read during working hours</li>
            <li>Introduce alcoholic drinks or strangers into the workplace</li>
            <li>Use working equipment or materials for personal purposes</li>
            <li>Indulge in illegal acts, whether in or out of duty</li>
            <li>Encourage or participate in actions that interfere with work</li>
            <li>Leave work without handing over to authorized personnel</li>
            <li>Argue with clients or visitors</li>
            <li>Act on behalf of the company without express authorization</li>
        </ol>
    </div>

    <div class="section">
        <h3>7. Acceptance of Terms</h3>
        <div class="clause">
            <p>I, <strong><?= htmlspecialchars($employee_name ?? '') ?></strong>, have read,
            understood, and accepted the terms and conditions stated in this contract.</p>
        </div>
    </div>
    <div class="section">
        <h3>8. Signatures</h3>
        <div class="sign-blocks">
            <div class="sign">
                <div><strong>Employer (Party of the first part)</strong></div>
                <div class="small">Signed on <?= htmlspecialchars($contract_date ?? date('Y-m-d')) ?></div>
            </div>
            <div class="sign">
                <div><strong>Employee (Party of the second part)</strong></div>
                <div class="small">Signed on <?= htmlspecialchars($contract_date ?? date('Y-m-d')) ?></div>
            </div>
        </div>
    </div> 
    <footer>
        <div><?= htmlspecialchars($company_name ?? 'SHEPHERD SECURITY AND CONSULTANCY INTERNATIONAL') ?> • <?= htmlspecialchars($company_contact ?? 'Tel: (237) 676037526') ?></div>
    </footer>
</div>
</body>
</html>