<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Security Service Agreement - <?= htmlspecialchars($contract_number ?? '') ?></title>

    <!-- Google font -->
    <link href="https://fonts.googleapis.com/css2?family=PT+Sans+Narrow:wght@400;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-color:
                <?= htmlspecialchars($primary_color ?? '#D2691E') ?>
            ;
            --accent-dark: #1f2937;
            --muted: #6b7280;
            --page-width: 800px;
        }

        html,
        body {
            font-family: 'PT Sans Narrow', Arial, sans-serif;
            color: #111827;
            margin: 0;
            padding: 0;
            -webkit-print-color-adjust: exact;
        }

        .page {
            width: var(--page-width);
            margin: 24px auto;
            padding: 28px 36px;
            box-sizing: border-box;
            background: #fff;
            color: #111;
        }

        header2 {
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 6px solid var(--primary-color);
            padding-bottom: 12px;
            margin-bottom: 18px;
        }

        .brand {
            display: flex;
            gap: 14px;
            align-items: center;
        }

        .brand .logo {
            width: 72px;
            height: 72px;
            border-radius: 8px;
            background: #f3f4f6;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            color: var(--primary-color);
            border: 2px solid rgba(0, 0, 0, 0.04);
        }

        .brand h1 {
            font-size: 20px;
            margin: 0;
            color: var(--accent-dark);
        }

        .meta {
            text-align: right;
            font-size: 12px;
            color: var(--muted)
        }

        .title {
            margin: 18px 0 6px 0;
            color: var(--accent-dark);
            font-size: 18px;
            font-weight: 700;
            text-align: center;
        }

        .sub {
            text-align: center;
            color: var(--muted);
            margin-bottom: 18px;
            font-size: 13px;
        }

        .section {
            margin: 12px 0 20px 0;
            line-height: 1.45;
            font-size: 13px;
        }

        .section h3 {
            color: var(--primary-color);
            margin: 0 0 6px 0;
            font-size: 14px;
        }

        .clause {
            margin: 8px 0;
        }

        .clause p {
            margin: 4px 0;
            text-indent: 18px;
        }

        ol.terms {
            margin: 8px 0 0 18px;
            padding: 0;
        }

        ol.terms>li {
            margin: 10px 0;
        }

        ol.subterms {
            margin: 6px 0 0 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
            font-size: 13px;
        }

        table th,
        table td {
            border: 1px solid #e5e7eb;
            padding: 8px 10px;
            text-align: left;
            vertical-align: top;
        }

        table th {
            background: linear-gradient(180deg, var(--primary-color), rgba(0, 0, 0, 0.02));
            color: #fff;
            font-weight: 700;
        }

        .price {
            text-align: right;
        }

        .sign-blocks {
            display: flex;
            gap: 20px;
            margin-top: 28px;
        }

        .sign {
            flex: 1;
            border-top: 1px solid #e5e7eb;
            padding-top: 8px;
            text-align: left;
            font-size: 13px;
        }

        .small {
            font-size: 12px;
            color: var(--muted);
        }

        footer {
            margin-top: 30px;
            border-top: 1px dashed #e5e7eb;
            padding-top: 10px;
            font-size: 12px;
            color: var(--muted);
            display: flex;
            justify-content: space-between;
        }

        /* watermark (optional) */
        .watermark {
            position: fixed;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%) rotate(-30deg);
            font-size: 72px;
            color: rgba(0, 0, 0, 0.03);
            z-index: 0;
            pointer-events: none;
        }

        /* printing */
        @media print {
            body {
                background: #fff;
            }

            .page {
                box-shadow: none;
                margin: 0;
            }
        }
         ol, ul {
    list-style: auto ;
    }
    </style>
</head>

<body>
    <div class="page">

        <!-- OPTIONAL watermark -->
        <?php if (!empty($show_watermark)): ?>
            <div class="watermark"><?= htmlspecialchars($watermark_text ?? 'SHEPHERD SECURITY') ?></div>
        <?php endif; ?>

        <header2>
            <div class="brand">
                <div class="logo"><?= htmlspecialchars($company_acronym ?? 'SSCI') ?></div>
                <div>
                    <h1><?= htmlspecialchars($company_name ?? 'Shepherd Security & Consultancy International') ?></h1>
                    <div class="small">
                        <?= htmlspecialchars($company_address ?? 'Opposite PCSS Buea Town, P.O.Box 554, Buea') ?></div>
                </div>
            </div>

            <div class="meta">
                <div>Document: <strong>Security Service Agreement</strong></div>
                <div>Contract No: <strong><?= htmlspecialchars($contract_number ?? '') ?></strong></div>
                <div>Date: <strong><?= htmlspecialchars(date('d/m/Y', strtotime($contract_date ?? date('Y-m-d')))) ?></strong></div>
            </div>
        </header2>

        <div class="title">SECURITY SERVICE AGREEMENT</div>
        <div class="sub">This Agreement is made between <br><strong
                style="font-size:20px;text-decoration: underline;">SHEPHERD SECURITY AND CONSULTANCY
                INTERNATIONAL</strong> <br>(the "Service Provider")<p style="padding:10px">and</p> <strong
                style="font-size:20px;text-decoration: underline;text-transform: uppercase;">{Post Name} (C/o {Facility Owner}}</strong>
            <br>
            (the "Facility Owner").
            <div style="margin-top: 10px; margin-bottom: 10px;" class="clause">Effective from <strong><?= htmlspecialchars(date('d/m/Y', strtotime($contract_start ?? ''))) ?></strong> to <strong><?= htmlspecialchars(date('d/m/Y', strtotime($contract_end ?? ''))) ?></strong> and shall remain in force for the operational period of the project for which the security services are engaged.
            </div>

        </div>


        <div class="section">
            <h3 style="font-size: 18px; font-weight: 900;"><strong>Terms & Conditions</strong></h3>

            <p class="clause">
                This Agreement embodies the entire understanding between the parties on the subject matter herein.
                No other commitment, term, or condition—oral or written, express or implied—shall apply unless expressly
                included in this Agreement.
            </p>

            <p class="clause">
                This Agreement may be extended for any additional period mutually agreed upon by both parties.
                The Client may terminate this Agreement at any time without assigning any reason by giving one (1)
                month's
                written notice to the Company. Similarly, the Company may terminate this Agreement by giving one (1)
                month's
                written notice to the Client.
            </p>

            

            <ol class="terms">

                <!-- 1 -->
                <li>
                    This Agreement shall remain valid for the duration of the project for which the Client has hired
                    guards
                    and is extendable by mutual consent. Either party may terminate the Agreement at any time by giving
                    the
                    other not less than one (1) month's written notice.

                    <ol class="subterms" type="a">
                        <li>The Client shall clear all outstanding dues before termination and during the notice period.
                        </li>
                        <li>If neither party alters or cancels the Agreement at the end of the stipulated period, it
                            shall
                            automatically continue on the same terms and conditions.</li>
                        <li>Company charges may be reviewed if national laws or wage adjustments cause changes in
                            operational
                            costs. A notification period of thirty (30) days shall apply before such changes take
                            effect.</li>
                        <li>If the Client abandons the project without clearing dues, the Company reserves the right to
                            seek
                            compensation through legal channels.</li>
                        <li>If the Client abandons the site and provides no notice within 30 days, the Company shall
                            notify the
                            Client’s available contacts and the local police. After seven (7) days from notice, the
                            Company may
                            withdraw services and shall bear no responsibility for losses thereafter.</li>
                        <li>If the Company abandons the site without notice, the Client reserves the right to seek legal
                            remedy.</li>
                        <li>Upon termination, the Company may withdraw all personnel and remove all Company-owned
                            equipment,
                            apparatus, or materials from the Client’s premises.</li>
                    </ol>
                </li>

                <!-- 2 -->
                <li>The Company shall provide detailed service specifications, instructions, duties and responsibilities
                    for supervisors and guards.</li>

                <!-- 3 -->
                <li>The Company shall supply reasonably educated staff capable of effectively discharging assigned
                    duties.</li>

                <!-- 4 -->
                <li>The Company is solely responsible for payment of wages and lawful compensation to its employees at
                    all times.</li>

                <!-- 5 -->
                <li>The Client shall not interfere with the Company’s right to hire or dismiss its employees.</li>

                <!-- 6 -->
                <li>All persons assigned under this Agreement are employees of the Company, not the Client.</li>

                <!-- 7 -->
                <li>The Client shall not persuade or entice Company staff to leave their employment or work directly for
                    the Client.</li>

                <!-- 8 -->
                <li>Security guards shall NOT be assigned tasks unrelated to security duties, including but not limited
                    to:
                    <ul class="small" style="margin-left:20px; margin-top:6px;">
                        <li>Transporting cash or valuables</li>
                        <li>Guarding vehicles outside the premises</li>
                        <li>Watering lawns or maintaining premises</li>
                        <li>Washing/cleaning vehicles or the compound</li>
                        <li>Fetching water, tea, utility items</li>
                        <li>Working in civil/plain clothes</li>
                        <li>Carrying or shifting luggage</li>
                        <li>Escorting Client or family outside the premises unless designated as mobile guard</li>
                        <li>Any activity that distracts them from primary security duties</li>
                    </ul>
                </li>

                <!-- 9 -->
                <li>The Company shall ensure none of its personnel assigned have criminal records or prior convictions.
                </li>

                <!-- 10 -->
                <li>
                    In the event of war, civil unrest, acts of God, or events beyond Company control, services may be
                    suspended.
                    The Client shall not be liable to pay for such suspended periods. Any prepaid sums shall be refunded
                    or credited
                    within thirty (30) days. The Client may terminate the Agreement during such suspension.
                </li>

                <!-- 11 -->
                <li>
                    The Company shall indemnify the Client against actual losses or damages resulting directly from
                    proven negligence
                    or infidelity of Company personnel (excluding cash/valuables unless insured by the Client).
                </li>

                <!-- 12 -->
                <li>
                    The Company shall indemnify the Client against claims arising from infringement of intellectual
                    property rights
                    resulting from Company’s actions or omissions.
                </li>

                <!-- 13 -->
                <li>
                    The Company is responsible for the proper use and handling of the Client’s equipment. Losses due to
                    proven
                    negligence of Company employees may result in compensation to the Client, subject to investigation
                    and FIR.
                </li>

                <!-- 14 -->
                <li>
                    The Company shall provide specifications for security equipment (batons, whistles, torches, etc.).
                    Proper training must be ensured, and equipment shall be periodically inspected.
                </li>

                <!-- 15 -->
                <li>
                    The Company operates as an independent contractor. Direction and manner of performance remain under
                    Company control.
                </li>

                <!-- 16 -->
                <li>
                    The Company is responsible for the conduct and behavior of its employees and shall ensure no
                    misconduct, nuisance,
                    negligence, or actions against the Client’s interest.
                </li>

                <!-- 17 -->
                <li>
                    The Company shall indemnify the Client for injuries or death of security personnel only to the
                    extent covered
                    by the Company’s insurance policies, except where the Client is legally responsible as employer.
                </li>

                <!-- 18 -->
                <li>
                    The Agreement shall be governed by the laws of Cameroon. The Company is responsible for payment of
                    all taxes and
                    statutory deductions.
                </li>

                <!-- 19 -->
                <li>
                    Disputes shall first be settled amicably. If unresolved, they shall be referred to arbitration by
                    four arbitrators
                    (two appointed by each party), under Cameroon Labour Code, at the Court in Buea.
                </li>

                <!-- 20 -->
                <li>
                    The Company shall not sublet, delegate, or transfer any rights under this Agreement.
                </li>

                <!-- 21 -->
                <li>
                    The Client shall provide necessary facilities at the service location(s), including accommodation,
                    lighting,
                    power, first aid, office furniture, drinking water, stationery, and any other required utilities.
                </li>

                <!-- 22 -->
                <li>
                    The Client shall not hand over cash or valuables to guards for personal transactions.
                    The Company shall not be responsible for any resulting loss.
                </li>

                <!-- 23 -->
                <li>
                    The Company shall not be responsible for unauthorized give/take transactions between guards and
                    Client or third parties.
                </li>

                <!-- 24 -->
                <li>
                    The Company shall conduct at least two (2) surprise inspections per month and submit written
                    reports.
                </li>

                <!-- 25 -->
                <li>
                    Monthly invoices shall be submitted within the last seven (7) working days of each month and are
                    payable not later
                    than the 5th of the following month.
                </li>

                <!-- 26 -->
                <li>
                    Failure to clear dues within sixty (60) days shall result in a final notice. Payment must be made
                    within seven (7) days.
                </li>

                <!-- 27 -->
                <li>
                    Failure to clear dues after the final notice entitles the Company to withdraw services without
                    further notice.
                </li>

                <!-- 28 -->
                <li>
                    Any dues outstanding thirty (30) days after termination may be pursued legally by the Company.
                </li>

                <!-- 29 -->
                <li>
                    Day security service runs from 06:00 to 18:00.
                    Night service runs from 18:00 to 06:00.
                </li>

                <!-- 30 -->
                <li>
                    Where applicable, security dogs may be deployed. Dogs remain Company property. The Company is not
                    liable for
                    injuries caused by the dog except where the handler is negligent.
                </li>

                <!-- 31 -->
                <li>
                    Where applicable, CCTV systems may be installed. The Company has access rights to recorded footage
                    but must
                    maintain confidentiality. Cameras and equipment remain Company property.
                </li>

            </ol>

            <div class="section" style="margin-top:20px;">
                <p>
                    Having read, understood, and accepted the above terms, this Agreement is executed for:
                </p>

                <p>
                    • The supply of <strong><?= htmlspecialchars($guards_day+$guards_night ?? '') ?></strong> security guards;
                    <strong><?= htmlspecialchars($guards_day ?? '') ?></strong> day guards and
                    <strong><?= htmlspecialchars($guards_night ?? '') ?></strong> night guards.<br>
                    • At Client premises located at: <strong><?= nl2br(htmlspecialchars($client_location ?? '________________________________________')) ?></strong><br><br>
                    • Monthly service cost as follows:
                </p>
                <div class="clause">

                    <table>
                        <thead>
                            <tr>
                                <th>Ref</th>
                                <th>Item</th>
                                <th>Q'ty</th>
                                <th>Unit Cost (XAF)</th>
                                <th class="price">Total (XAF)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($service_lines ?? [['description' => 'Rotation Guards', 'qty' => 1, 'unit' => 40000, 'total' => 40000]] as $line): ?>
                                <tr>
                                    <td><?= htmlspecialchars($line['ref'] ?? '') ?></td>
                                    <td><?= htmlspecialchars($line['description'] ?? '') ?></td>
                                    <td><?= htmlspecialchars($line['qty'] ?? '') ?></td>
                                    <td><?= htmlspecialchars(number_format($line['unit'] ?? 0, 0, '.', ',')) ?></td>
                                    <td class="price">
                                        <?= htmlspecialchars(number_format($line['total'] ?? 0, 2, '.', ',')) ?></td>
                                </tr>
                            <?php endforeach; ?>
                            <tr>
                                <td colspan="4" style="text-align:right; font-weight:700">Grand Total</td>
                                <td class="price" style="font-weight:700">
                                    <?= htmlspecialchars(number_format($grand_total ?? 0, 2, '.', ',')) ?></td>
                            </tr>
                        </tbody>
                    </table>
                    <p>
                        <strong>Amount in words:</strong>
                        <?= htmlspecialchars($amount_in_words ?? '________________________________________') ?> francs CFA only.
                    </p>
                </div>
            </div>
        </div>


        <div class="section" style="margin-top: 20px;">
            <div class="sign-blocks">
                <div class="sign" style="margin-bottom: 50px;">
                    <div><strong>Client (Party of the one part)</strong></div>
                    <div style="margin-top:22px;">Name:
                        <?= htmlspecialchars($client_rep_name ?? '_____________________') ?></div>
                    <div style="margin-top:6px;">Signature: _______________________</div>
                </div>

                <div class="sign">
                    <div><strong>Company (Party of the other part)</strong></div>
                    <div style="margin-top:22px;">Name:
                        <?= htmlspecialchars($company_rep_name ?? '_____________________') ?></div>
                    <div style="margin-top:6px;">Signature: _______________________</div>
                </div>
            </div>
        </div>

        <footer>
            <div><?= htmlspecialchars($company_name ?? 'SHEPHERD SECURITY AND CONSULTANCY INTERNATIONAL') ?> •
                <?= htmlspecialchars($company_contact ?? 'Tel: (237) 676037526') ?></div>
        </footer>
    </div>
</body>

</html>