<?php
/**
 * Client - Profile
 * View and edit client profile
 */

$auth = $GLOBALS['auth'];
$db = $GLOBALS['db'];

// Get current user
$user = $db->fetch("SELECT * FROM users WHERE id = ? AND role = 'client'", [$_SESSION['user_id'] ?? 0]);
if (!$user) {
    header('Location: ?page=login');
    exit();
}

// Handle profile update
$message = null;
$message_type = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_profile'])) {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $company = $_POST['company_name'] ?? '';
    $contact_person = $_POST['contact_person'] ?? '';
    $zone = $_POST['zone'] ?? '';

    if (!empty($name) && !empty($email)) {
        $result = $db->query(
            "UPDATE users SET name = ?, email = ?, phone = ? WHERE id = ?",
            [$name, $email, $phone, $_SESSION['user_id']]
        );

        if ($result) {
            $message = 'Profile updated successfully!';
            $message_type = 'success';
            $user = $db->fetch("SELECT * FROM users WHERE id = ?", [$_SESSION['user_id']]);
        } else {
            $message = 'Failed to update profile';
            $message_type = 'error';
        }
    } else {
        $message = 'Please fill in all required fields';
        $message_type = 'error';
    }
}

require_once __DIR__ . '/../layouts/header.php';
?>

<div class="container mx-auto px-4 py-8 max-w-3xl">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <h1 class="text-4xl font-bold text-gray-800">
                <i class="fas fa-user text-blue-600 mr-3"></i>Profile
            </h1>
            <a href="?page=clients/dashboard" class="px-6 py-3 bg-gray-600 text-white rounded-lg hover:bg-gray-700 font-semibold">
                <i class="fas fa-arrow-left mr-2"></i>Back
            </a>
        </div>
    </div>

    <!-- Message Alert -->
    <?php if ($message): ?>
        <div class="mb-6 p-4 rounded-lg <?php echo $message_type === 'success' ? 'bg-green-50 text-green-700 border border-green-200' : 'bg-red-50 text-red-700 border border-red-200'; ?>">
            <i class="fas fa-<?php echo $message_type === 'success' ? 'check-circle' : 'exclamation-circle'; ?> mr-2"></i>
            <?php echo htmlspecialchars($message); ?>
        </div>
    <?php endif; ?>

    <!-- Profile Form -->
    <div class="bg-white rounded-lg shadow border border-gray-200">
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
            <h2 class="text-xl font-bold text-gray-800">
                <i class="fas fa-edit text-blue-600 mr-2"></i>Edit Profile
            </h2>
        </div>

        <form method="POST" class="p-6 space-y-6">
            <input type="hidden" name="update_profile" value="1">

            <!-- Name -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Full Name *</label>
                <input type="text" name="name" value="<?php echo htmlspecialchars($user['name'] ?? ''); ?>" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
            </div>

            <!-- Email -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Email *</label>
                <input type="email" name="email" value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
            </div>

            <!-- Phone -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Phone Number</label>
                <input type="tel" name="phone" value="<?php echo htmlspecialchars($user['phone'] ?? ''); ?>"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
            </div>

            <!-- Company Name -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Company Name</label>
                <input type="text" name="company_name" value="<?php echo htmlspecialchars($user['company_name'] ?? ''); ?>"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                    disabled>
            </div>

            <!-- Contact Person -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Contact Person</label>
                <input type="text" name="contact_person" value="<?php echo htmlspecialchars($user['contact_person'] ?? ''); ?>"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                    disabled>
            </div>

            <!-- Zone -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Zone</label>
                <input type="text" name="zone" value="<?php echo htmlspecialchars($user['zone'] ?? ''); ?>"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                    disabled>
            </div>

            <!-- Buttons -->
            <div class="flex gap-3 pt-4 border-t border-gray-200">
                <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 font-semibold">
                    <i class="fas fa-save mr-2"></i>Save Changes
                </button>
                <a href="?page=clients/dashboard" class="px-6 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50">
                    Cancel
                </a>
            </div>
        </form>
    </div>

    <!-- Account Info -->
    <div class="mt-8 bg-white rounded-lg shadow border border-gray-200 p-6">
        <h3 class="text-lg font-bold text-gray-800 mb-4">
            <i class="fas fa-info-circle text-gray-600 mr-2"></i>Account Information
        </h3>
        <div class="space-y-3">
            <div class="flex justify-between">
                <span class="text-gray-600">Member Since</span>
                <span class="font-semibold text-gray-800"><?php echo date('M d, Y', strtotime($user['created_at'] ?? 'now')); ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-gray-600">Role</span>
                <span class="font-semibold text-gray-800">Client</span>
            </div>
            <div class="flex justify-between">
                <span class="text-gray-600">Status</span>
                <span class="inline-block px-3 py-1 bg-green-100 text-green-700 rounded-full text-sm font-semibold">Active</span>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
