<?php
/**
 * Client - My Feedbacks (Readonly)
 * View all feedbacks given for client's posts
 */

$auth = $GLOBALS['auth'];
$db = $GLOBALS['db'];

// Get current user
$user = $db->fetch("SELECT id, name FROM users WHERE id = ? AND role = 'client'", [$_SESSION['user_id'] ?? 0]);
if (!$user) {
    header('Location: ?page=dashboard');
    exit();
}

// Get feedbacks for user with guard and post info
$feedbacks = $db->fetchAll(
    "SELECT f.*, u.name as guard_name, p.name as post_name
     FROM feedback f
     LEFT JOIN users u ON f.Client = u.id
     LEFT JOIN posts p ON u.id = p.owner_id
     WHERE f.Client = ?
     ORDER BY f.Date DESC",
    [$_SESSION['user_id']]
);

require_once __DIR__ . '/../layouts/header.php';
?>

<div class="container mx-auto px-4 py-8 max-w-7xl">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <h1 class="text-4xl font-bold text-gray-800">
                <i class="fas fa-star text-yellow-600 mr-3"></i>My Feedbacks
            </h1>
            <a href="?page=clients/dashboard" class="px-6 py-3 bg-gray-600 text-white rounded-lg hover:bg-gray-700 font-semibold">
                <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
            </a>
        </div>
        <p class="text-gray-600 mt-2">
            Total feedbacks: <span class="font-bold text-yellow-600"><?php echo count($feedbacks); ?></span>
        </p>
    </div>

    <!-- Feedbacks Cards -->
    <?php if (!empty($feedbacks)): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <?php foreach ($feedbacks as $feedback): ?>
                <div class="bg-white rounded-lg shadow border border-gray-200 hover:shadow-lg transition overflow-hidden">
                    <!-- Header -->
                    <div class="bg-gradient-to-r from-yellow-600 to-yellow-700 p-4 text-white">
                        <div class="flex items-start justify-between">
                            <div>
                                <h3 class="text-lg font-bold"><?php echo htmlspecialchars($feedback['guard_name'] ?? 'Unknown Guard'); ?></h3>
                                <p class="text-yellow-100 text-sm">
                                    <i class="fas fa-map-pin mr-1"></i><?php echo htmlspecialchars($feedback['post_name'] ?? 'Unknown Post'); ?>
                                </p>
                            </div>
                            <div class="text-right">
                                <div class="flex gap-1">
                                    <?php $score = intval($feedback['Overall_Score'] ?? 0); for ($i = 0; $i < 5; $i++): ?>
                                        <i class="fas fa-star <?php echo $i < $score ? 'text-yellow-300' : 'text-yellow-100'; ?>"></i>
                                    <?php endfor; ?>
                                </div>
                                <p class="text-xs text-yellow-100 mt-1"><?php echo $score; ?>/5</p>
                            </div>
                        </div>
                    </div>

                    <!-- Content -->
                    <div class="p-6 space-y-4">
                        <!-- Feedback Subject -->
                        <div>
                            <p class="font-semibold text-gray-800"><?php echo htmlspecialchars($feedback['Subject'] ?? 'Feedback'); ?></p>
                        </div>

                        <!-- Feedback Remarks -->
                        <div>
                            <p class="text-sm text-gray-700"><?php echo htmlspecialchars($feedback['Remarks'] ?? 'No remarks'); ?></p>
                        </div>

                        <!-- Score Breakdown -->
                        <div class="bg-gray-50 rounded p-3 space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Guard Score:</span>
                                <span class="font-semibold text-blue-600"><?php echo $feedback['Guard_Score'] ?? '-'; ?>/5</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Controller Score:</span>
                                <span class="font-semibold text-green-600"><?php echo $feedback['Controller_Score'] ?? '-'; ?>/5</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Management Score:</span>
                                <span class="font-semibold text-purple-600"><?php echo $feedback['Management_Score'] ?? '-'; ?>/5</span>
                            </div>
                        </div>

                        <!-- Meta Info -->
                        <div class="pt-4 border-t border-gray-200 text-xs text-gray-600">
                            <p>
                                <i class="fas fa-calendar mr-1"></i>
                                <?php echo date('M d, Y', strtotime($feedback['Date'] ?? date('Y-m-d'))); ?>
                            </p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-lg shadow border border-gray-200 p-12 text-center">
            <i class="fas fa-inbox text-5xl text-gray-300 mb-4"></i>
            <p class="text-gray-500 text-lg">No feedbacks yet</p>
            <p class="text-gray-400 text-sm mt-2">Feedbacks about your guards will appear here</p>
            <a href="?page=clients/create-feedback" class="inline-block mt-4 px-6 py-2 bg-yellow-600 text-white rounded-lg hover:bg-yellow-700 font-semibold">
                <i class="fas fa-plus mr-2"></i>Give Feedback
            </a>
        </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
