<?php
/**
 * Reset Password Page
 * SSCI Office Platform
 */

require_once __DIR__ . '/../../config/bootstrap.php';

$auth = $GLOBALS['auth'];

// Redirect if already logged in
if ($auth->isAuthenticated()) {
    header('Location: index.php?page=dashboard');
    exit();
}

// Handle language switching
if (isset($_GET['lang']) && in_array($_GET['lang'], ['en', 'fr'])) {
    load_language($_GET['lang']);
    header('Location: ?page=reset-password&token=' . ($_GET['token'] ?? ''));
    exit();
}

$token = $_GET['token'] ?? '';
$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    
    if ($password !== $confirm_password) {
        $error = trans('error_password_mismatch');
    } elseif (empty($password) || strlen($password) < 8) {
        $error = trans('error_short_password');
    } else {
        // TODO: Update password with token verification
        $message = trans('password_reset_success');
    }
}

$pageTitle = trans('reset_password') . ' - ' . config('app.name');

require_once __DIR__ . '/header.php';
?>

<div class="bg-white rounded-lg shadow-xl p-8 animate__animated animate__fadeInUp">
    <div class="text-center mb-8">
        <img src="<?php echo config('app.ui.site_logo'); ?>" alt="Logo" class="h-16 mx-auto mb-4">
        <h1 class="text-3xl font-bold text-gray-800"><?php echo config('app.acronym'); ?></h1>
        <p class="text-gray-600 mt-2"><?php echo config('app.company'); ?></p>
    </div>

    <?php if ($error): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-exclamation-circle"></i> <?php echo e($error); ?>
        </div>
    <?php endif; ?>

    <?php if ($message): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-check-circle"></i> <?php echo e($message); ?>
            <p class="text-sm mt-2"><?php echo trans('redirecting'); ?> <a href="?page=login" class="font-bold"><?php echo trans('login'); ?></a></p>
        </div>
    <?php endif; ?>

    <form method="POST" action="">
        <input type="hidden" name="token" value="<?php echo e($token); ?>">
        
        <div class="mb-4">
            <label for="password" class="block text-gray-700 font-bold mb-2"><?php echo trans('password'); ?></label>
            <input type="password" name="password" id="password" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500" placeholder="<?php echo trans('password'); ?>" required>
        </div>

        <div class="mb-6">
            <label for="confirm_password" class="block text-gray-700 font-bold mb-2"><?php echo trans('confirm_password'); ?></label>
            <input type="password" name="confirm_password" id="confirm_password" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500" placeholder="<?php echo trans('confirm_password'); ?>" required>
            <small class="text-gray-500"><?php echo trans('min_8_characters') ?? '8 characters minimum'; ?></small>
        </div>

        <button type="submit" class="w-full bg-blue-600 text-white font-bold py-2 px-4 rounded-lg hover:bg-blue-700 transition">
            <i class="fas fa-key"></i> <?php echo trans('reset_password'); ?>
        </button>
    </form>

    <div class="mt-6 text-center">
        <p class="text-gray-600">
            <a href="?page=login" class="text-blue-600 font-bold hover:text-blue-800"><?php echo trans('back'); ?> <?php echo trans('login'); ?></a>
        </p>
    </div>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
