<?php
/**
 * Register Page
 * SSCI Office Platform
 */

require_once __DIR__ . '/../../config/bootstrap.php';

$auth = $GLOBALS['auth'];

// Redirect if already logged in
if ($auth->isAuthenticated()) {
    header('Location: index.php?page=dashboard');
    exit();
}

// Handle language switching
if (isset($_GET['lang']) && in_array($_GET['lang'], ['en', 'fr'])) {
    load_language($_GET['lang']);
    header('Location: ?page=register');
    exit();
}

// Handle registration form submission
$error = '';
$success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    $name = $_POST['name'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $address = $_POST['address'] ?? '';

    // Validation
    if (empty($email) || empty($password) || empty($name)) {
        $error = trans('error_invalid_input');
    } elseif ($password !== $confirm_password) {
        $error = trans('error_password_mismatch');
    } elseif (strlen($password) < 8) {
        $error = trans('error_short_password');
    } else {
        if ($auth->register([
            'name' => $name,
            'email' => $email,
            'password' => $password,
            'phone' => $phone,
            'address' => $address,
            'role' => 'guard',
        ])) {
            $success = trans('registration_successful');
        } else {
            $error = trans('error_email_exists');
        }
    }
}

$pageTitle = trans('register') . ' - ' . config('app.name');

require_once __DIR__ . '/header.php';
?>

<div class="bg-white rounded-lg shadow-xl animate__animated animate__fadeInUp overflow-hidden">
    <div class="grid grid-cols-1 md:grid-cols-2">
        <!-- Left Column - Form -->
        <div class="p-8">
            <div class="mb-8">
                <h1 class="text-3xl font-bold text-gray-800"><?php echo trans('register'); ?></h1>
                <p class="text-gray-600 mt-2"><?php echo trans('join_us') ?? config('app.company'); ?></p>
            </div>

            <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <i class="fas fa-exclamation-circle"></i> <?php echo e($error); ?>
                </div>
            <?php endif; ?>

            <?php if ($success): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <i class="fas fa-check-circle"></i> <?php echo e($success); ?>
                    <p class="text-sm mt-2"><?php echo trans('redirecting'); ?></p>
                </div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="mb-4">
                    <label for="name" class="block text-gray-700 font-bold mb-2"><?php echo trans('full_name'); ?></label>
                    <input type="text" id="name" name="name" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500" placeholder="<?php echo trans('full_name'); ?>">
                </div>

                <div class="mb-4">
                    <label for="email" class="block text-gray-700 font-bold mb-2"><?php echo trans('email'); ?></label>
                    <input type="email" id="email" name="email" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500" placeholder="<?php echo trans('email'); ?>">
                </div>

                <div class="mb-4">
                    <label for="password" class="block text-gray-700 font-bold mb-2"><?php echo trans('password'); ?></label>
                    <input type="password" id="password" name="password" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500" placeholder="<?php echo trans('password'); ?>">
                    <small class="text-gray-500"><?php echo trans('min_8_characters') ?? '8 characters minimum'; ?></small>
                </div>

                <div class="mb-4">
                    <label for="confirm_password" class="block text-gray-700 font-bold mb-2"><?php echo trans('confirm_password'); ?></label>
                    <input type="password" id="confirm_password" name="confirm_password" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500" placeholder="<?php echo trans('confirm_password'); ?>">
                </div>

                <button type="submit" class="w-full bg-blue-600 text-white font-bold py-2 px-4 rounded-lg hover:bg-blue-700 transition">
                    <i class="fas fa-user-plus"></i> <?php echo trans('sign_up'); ?>
                </button>
            </form>

            <div class="mt-6 text-center">
                <p class="text-gray-600"><?php echo trans('have_account'); ?> 
                    <a href="?page=login" class="text-blue-600 font-bold hover:text-blue-800"><?php echo trans('login'); ?></a>
                </p>
            </div>
        </div>

        <!-- Right Column - Info -->
        <div class="hidden md:flex md:flex-col md:justify-between md:p-8 md:bg-gradient-to-br md:from-blue-600 md:to-blue-800 md:text-white">
            <div>
                <img src="<?php echo config('app.ui.site_logo'); ?>" alt="Logo" class="h-12 mb-6">
                <h2 class="text-2xl font-bold mb-4"><?php echo config('app.acronym'); ?></h2>
                <p class="mb-6"><?php echo config('app.company'); ?></p>
                <p class="text-blue-100"><?php echo trans('welcome') ?? 'Secure and professional security management platform'; ?></p>
            </div>
            <div class="space-y-4">
                <div class="flex items-start space-x-3">
                    <i class="fas fa-check-circle text-2xl mt-1"></i>
                    <div>
                        <h3 class="font-bold"><?php echo trans('fast_setup') ?? 'Fast Setup'; ?></h3>
                        <p class="text-blue-100 text-sm"><?php echo trans('get_started_quickly') ?? 'Get started in minutes'; ?></p>
                    </div>
                </div>
                <div class="flex items-start space-x-3">
                    <i class="fas fa-shield-alt text-2xl mt-1"></i>
                    <div>
                        <h3 class="font-bold"><?php echo trans('secure') ?? 'Secure'; ?></h3>
                        <p class="text-blue-100 text-sm"><?php echo trans('enterprise_grade') ?? 'Enterprise-grade security'; ?></p>
                    </div>
                </div>
                <div class="flex items-start space-x-3">
                    <i class="fas fa-redo text-2xl mt-1"></i>
                    <div>
                        <h3 class="font-bold"><?php echo trans('support') ?? '24/7 Support'; ?></h3>
                        <p class="text-blue-100 text-sm"><?php echo trans('always_here') ?? 'Always here to help'; ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
