<!DOCTYPE html>
<html lang="<?php echo current_language(); ?>" dir="<?php echo text_direction(); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="<?php echo config('app.ui.primary_color'); ?>">
    <title><?php echo e($pageTitle ?? config('app.name') . ' - ' . config('app.company')); ?></title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Google Fonts - PT Sans Narrow -->
    <link href="https://fonts.googleapis.com/css2?family=PT+Sans+Narrow:wght@400;700&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo config('app.url'); ?>/css/main.css">
    
    <!-- Animate.js -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    
    <!-- SweetAlert2 for toast notifications -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="<?php echo config('app.url'); ?>/manifest.json">
    <link rel="icon" type="image/png" href="<?php echo config('app.ui.site_logo'); ?>">
    <link rel="apple-touch-icon" href="<?php echo config('app.ui.site_logo'); ?>">
    
    <style>
        * {
            font-family: 'PT Sans Narrow', sans-serif;
        }
        
        :root {
            --primary-color: <?php echo config('app.ui.primary_color'); ?>;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
</head>
<body>
    <!-- Language Switcher -->
    <div class="absolute top-4 right-4">
        <div class="relative">
            <button id="languageBtn" class="flex items-center space-x-2 text-white hover:text-gray-200 bg-white bg-opacity-20 px-4 py-2 rounded-lg transition">
                <i class="fas fa-globe"></i>
                <span><?php echo current_language() === 'en' ? 'English' : 'Français'; ?></span>
            </button>
            <div id="languageMenu" class="hidden absolute right-0 mt-2 w-32 bg-white rounded shadow-lg">
                <a href="?page=<?php echo $_GET['page'] ?? 'login'; ?>&lang=en" class="block px-4 py-2 text-gray-700 hover:bg-blue-50">🇬🇧 English</a>
                <a href="?page=<?php echo $_GET['page'] ?? 'login'; ?>&lang=fr" class="block px-4 py-2 text-gray-700 hover:bg-blue-50">🇫🇷 Français</a>
            </div>
        </div>
    </div>

    <div class="w-full max-w-md mx-auto px-4">
