<?php
/**
 * Forgot Password Page
 * SSCI Office Platform
 */

require_once __DIR__ . '/../../config/bootstrap.php';

$auth = $GLOBALS['auth'];

// Redirect if already logged in
if ($auth->isAuthenticated()) {
    header('Location: index.php?page=dashboard');
    exit();
}

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    
    if (!empty($email)) {
        // TODO: Send password reset email
        $message = 'Check your email for password reset instructions';
    }
}

$pageTitle = trans('reset_password') . ' - ' . config('app.name');

require_once __DIR__ . '/../layouts/header.php';
?>

<div class="grid grid-justify mt-20 bg-white rounded-lg shadow-xl p-8 animate__animated animate__fadeInUp">
    <div class="text-center mb-8">
        <img src="/ssci<?php echo config('app.ui.site_logo'); ?>" alt="Logo" class="h-16 mx-auto mb-4">
        <h1 class="text-3xl font-bold text-gray-800"><?php echo config('app.acronym'); ?></h1>
        <p class="text-gray-600 mt-2"><?php echo config('app.company'); ?></p>
    </div>

    <?php if ($message): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-check-circle"></i> <?php echo e($message); ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="">
        <div class="mb-4">
            <label for="email" class="block text-gray-700 font-bold mb-2"><?php echo trans('email'); ?></label>
            <input type="email" name="email" id="email" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>

        <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded-lg hover:bg-blue-700 transition">
            <?php echo trans('submit'); ?>
        </button>

        <p class="text-center mt-4 text-gray-600">
            <?php echo trans('back'); ?> <a href="?page=login" class="text-blue-600 hover:underline"><?php echo trans('login'); ?></a>
        </p>
    </form>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
