<?php
// Serve manifest with correct MIME type - NO BOOTSTRAP
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: public, max-age=3600');
header('Access-Control-Allow-Origin: *');

// Get base URL from request
$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$baseUrl = $protocol . '://' . $host;

// Build manifest
$manifest = array(
    "name" => "SSCI Office",
    "short_name" => "SSCI",
    "description" => "Comprehensive security company management platform",
    "start_url" => $baseUrl . "/index.php?page=dashboard",
    "scope" => "/",
    "display" => "standalone",
    "orientation" => "portrait-primary",
    "theme_color" => "#2563eb",
    "background_color" => "#ffffff",
    "icons" => array(
        array(
            "src" => $baseUrl . "/images/logo-192.png",
            "sizes" => "192x192",
            "type" => "image/png",
            "purpose" => "any"
        ),
        array(
            "src" => $baseUrl . "/images/logo-512.png",
            "sizes" => "512x512",
            "type" => "image/png",
            "purpose" => "any"
        )
    )
);

echo json_encode($manifest, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
exit;
?>
