<?php
/**
 * Static Asset Server
 * Serves manifest and service worker with correct MIME types
 */

$file = $_GET['file'] ?? '';

// Whitelist allowed files
$allowedFiles = [
    'manifest' => [
        'path' => 'manifest.json',
        'mime' => 'application/json'
    ],
    'worker' => [
        'path' => 'service-worker.js',
        'mime' => 'application/javascript'
    ]
];

if (!isset($allowedFiles[$file])) {
    header('HTTP/1.0 404 Not Found');
    exit;
}

$fileInfo = $allowedFiles[$file];
$filePath = __DIR__ . '/' . $fileInfo['path'];

if (!file_exists($filePath)) {
    header('HTTP/1.0 404 Not Found');
    exit;
}

header('Content-Type: ' . $fileInfo['mime'] . '; charset=utf-8');
header('Cache-Control: public, max-age=3600');
header('Access-Control-Allow-Origin: *');

readfile($filePath);
exit;
?>
