<?php
/**
 * English Language File
 * SSCI Office Platform
 */

return [
    // General
    'app_name' => 'SSCI Office',
    'company_name' => 'Shepherd Security and Consultancy International',
    'welcome' => 'Welcome',
    'login' => 'Login',
    'logout' => 'Logout',
    'register' => 'Register',
    'email' => 'Email',
    'password' => 'Password',
    'confirm_password' => 'Confirm Password',
    'remember_me' => 'Remember Me',
    'forgot_password' => 'Forgot Password?',
    'sign_in' => 'Sign In',
    'sign_up' => 'Sign Up',
    'reset_password' => 'Reset Password',
    'submit' => 'Submit',
    'cancel' => 'Cancel',
    'save' => 'Save',
    'update' => 'Update',
    'delete' => 'Delete',
    'edit' => 'Edit',
    'view' => 'View',
    'add' => 'Add',
    'back' => 'Back',
    'close' => 'Close',
    'confirm' => 'Confirm',
    'user' => 'User',
    'english' => 'English',
    'french' => 'Français',

    // Dashboard
    'dashboard' => 'Dashboard',
    'welcome_to_dashboard' => 'Welcome to SSCI Office Dashboard',
    'total_clients' => 'Total Clients',
    'total_posts' => 'Total Posts',
    'total_staff' => 'Total Staff',
    'total_revenue' => 'Total Revenue',
    'recent_activity' => 'Recent Activity',

    // Navigation
    'menu' => 'Menu',
    'clients' => 'Clients',
    'staff' => 'Staff',
    'posts' => 'Posts',
    'finances' => 'Finances',
    'controls' => 'Guards Controls',
    'guards' => 'Guard Management',
    'patrols' => 'Patrols',
    'messages' => 'Messages',
    'settings' => 'Settings',
    'evaluations' => 'Evaluations',
    'reports' => 'Reports',
    'profile' => 'Profile',
    'language' => 'Language',
    'arabic' => 'العربية',

    // Clients
    'manage_clients' => 'Manage Clients',
    'account_information' => 'Account Information',
    'select_account' => 'Select Account',
    'choose_account' => 'Choose an account...',
    'client_name' => 'Client Name',
    'client_email' => 'Client Email',
    'client_phone' => 'Client Phone',
    'client_address' => 'Client Address',
    'company_type' => 'Company Type',
    'select_company_type' => 'Select a company type...',
    'contact_person' => 'Contact Person',
    'add_client' => 'Add Client',
    'edit_client' => 'Edit Client',
    'delete_client' => 'Delete Client',
    'save_client' => 'Save Client',

    // Posts
    'manage_posts' => 'Manage Security Posts',
    'facilities' => 'Facilities & Posts',
    'add_facility' => 'Add Facility',
    'edit_facility' => 'Edit Facility',
    'facility_name' => 'Facility Name',
    'facility_type' => 'Facility Type',
    'facility_information' => 'Facility Information',
    'facility_location' => 'Facility Location',
    'facility_saved' => 'Facility saved successfully',
    'no_facilities_yet' => 'No facilities added yet',
    'select_type' => 'Select facility type...',
    'select_owner' => 'Choose owner...',
    'location' => 'Location',
    'owner' => 'Facility Owner',
    'owner_address' => 'Owner Address',
    'location_coordinates' => 'Location Coordinates',
    'my_position' => 'My Position',
    'site_assessment' => 'Site Assessment',
    'internal_factors' => 'Internal Factors',
    'external_factors' => 'External Factors',
    'overall_risk_score' => 'Overall Risk Score',
    'calculated_from_all_factors' => 'Automatically calculated from all assessment factors',
    'risk_level' => 'Risk Level',
    'high_risk' => 'High Risk',
    'medium_risk' => 'Medium Risk',
    'low_risk' => 'Low Risk',
    'high' => 'High',
    'medium' => 'Medium',
    'low' => 'Low',
    'confirm_delete_facility' => 'Are you sure you want to delete this facility?',
    'facility_name_required' => 'Facility name is required',
    'latitude' => 'Latitude',
    'longitude' => 'Longitude',
    'current' => 'Current',
    'position_updated' => 'Position updated',
    'save_facility' => 'Save Facility',
    'post_name' => 'Post Name',
    'post_owner' => 'Post Owner',
    'contract_date' => 'Contract Date',
    'billing_address' => 'Billing Address',
    'add_post' => 'Add Post',
    'edit_post' => 'Edit Post',
    'delete_post' => 'Delete Post',
    'assessment' => 'Assessment',
    'zone' => 'Zone',
    'select_zone' => 'Select zone...',

    // Guards Management
    'assign_guards_to_posts' => 'Assign Guards to Posts',
    'guard_assignment' => 'Guard Assignment',
    'assign_guard' => 'Assign Guard',
    'assign_first_guard' => 'Assign First Guard',
    'assigned_guards' => 'Assigned Guards',
    'available_guards' => 'Available Guards',
    'filter_guards' => 'Filter Guards',
    'assignment_date' => 'Assignment Date',
    'assignment_start_date' => 'Start Date',
    'assignment_end_date' => 'End Date (Optional)',
    'guard_controls' => 'Guard Controls',
    'record_control' => 'Record Control',
    'control_history' => 'Control History',
    'attendance_punctuality' => 'Attendance & Punctuality',
    'uniform_presentation' => 'Uniform & Presentation',
    'patrol_reporting_discipline' => 'Patrol & Reporting Discipline',
    'client_feedback' => 'Client Feedback',
    'general_evaluation' => 'General Evaluation',
    'control_notes' => 'Control Notes',
    'scan_qr_code' => 'Scan QR Code',
    'qr_scanner' => 'QR Scanner',
    'guard_id' => 'Guard ID',
    'control_date_time' => 'Control Date & Time',
    'geolocation' => 'Geolocation',
    'get_current_location' => 'Get Current Location',
    'latitude' => 'Latitude',
    'longitude' => 'Longitude',
    'accuracy' => 'Accuracy',
    'capture_photo' => 'Capture Photo',
    'photo_captured' => 'Photo Captured',
    'submit_control' => 'Submit Control',
    'control_recorded' => 'Control recorded successfully',

    // Staff
    'manage_staff' => 'Manage Staff',
    'staff_name' => 'Staff Name',
    'staff_role' => 'Role',
    'staff_email' => 'Email',
    'staff_phone' => 'Phone',
    'add_staff' => 'Add Staff Member',
    'edit_staff' => 'Edit Staff Member',
    'delete_staff' => 'Delete Staff Member',

    // Finances
    'invoices' => 'Invoices',
    'payments' => 'Payments',
    'salaries' => 'Salaries',
    'expenses' => 'Expenses',
    'financial_reports' => 'Financial Reports',
    'invoice_number' => 'Invoice Number',
    'invoice_date' => 'Invoice Date',
    'due_date' => 'Due Date',
    'amount' => 'Amount',
    'total_amount' => 'Total Amount',
    'payment_status' => 'Payment Status',
    'add_invoice' => 'Add Invoice',
    'edit_invoice' => 'Edit Invoice',
    'delete_invoice' => 'Delete Invoice',

    // Guards Controls
    'guards_controls' => 'Guards Controls',
    'add_control' => 'Add Control',
    'edit_control' => 'Edit Control',
    'delete_control' => 'Delete Control',
    'guard' => 'Guard',
    'controller' => 'Controller',
    'control_date' => 'Control Date',
    'score' => 'Score',
    'attendance_punctuality' => 'Attendance & Punctuality',
    'uniform_presentation' => 'Uniform & Presentation',
    'patrol_reporting' => 'Patrol & Reporting Discipline',
    'client_feedback' => 'Client Feedback',
    'overall_evaluation' => 'Overall Evaluation',

    // Evaluations
    'evaluations' => 'Evaluations',
    'controllers_evaluations' => 'Controllers Evaluations',
    'managers_evaluations' => 'Managers Evaluations',
    'evaluation_period' => 'Evaluation Period',
    'add_evaluation' => 'Add Evaluation',
    'edit_evaluation' => 'Edit Evaluation',

    // Messages
    'new_message' => 'New Message',
    'send_message' => 'Send Message',
    'message_subject' => 'Subject',
    'message_body' => 'Message',
    'recipient' => 'Recipient',
    'sender' => 'Sender',
    'inbox' => 'Inbox',
    'sent' => 'Sent',
    'compose' => 'Compose',
    'subject' => 'Subject',
    'message' => 'Message',
    'attachments' => 'Attachments',
    'no_messages' => 'No messages',

    // Client Section
    'my_dashboard' => 'My Dashboard',
    'my_post' => 'My Post',
    'my_posts' => 'My Posts',
    'my_guards' => 'My Guards',
    'my_controls' => 'My Controls',
    'my_feedbacks' => 'Feedbacks',
    'my_patrols' => 'My Patrols',
    'my_payments' => 'My Payments',
    'my_invoices' => 'My Invoices',
    'posts_in_zone' => 'Posts in Zone',
    'contract' => 'Contract',
    'site_assessment' => 'Site Assessment',
    'user_management' => 'User Management',

    // Settings
    'site_settings' => 'Site Settings',
    'site_name' => 'Site Name',
    'site_acronym' => 'Site Acronym',
    'site_logo' => 'Site Logo',
    'site_letterhead' => 'Site Letterhead',
    'primary_color' => 'Primary Color',
    'whatsapp_api_token' => 'WhatsApp API Token',
    'sms_gateway_token' => 'SMS Gateway Token',
    'email_settings' => 'Email Settings',
    'notification_settings' => 'Notification Settings',

    // Status
    'active' => 'Active',
    'inactive' => 'Inactive',
    'pending' => 'Pending',
    'completed' => 'Completed',
    'approved' => 'Approved',
    'rejected' => 'Rejected',
    'paid' => 'Paid',
    'unpaid' => 'Unpaid',
    'draft' => 'Draft',

    // Messages
    'success' => 'Success',
    'error' => 'Error',
    'warning' => 'Warning',
    'info' => 'Information',
    'record_saved' => 'Record saved successfully',
    'record_updated' => 'Record updated successfully',
    'record_deleted' => 'Record deleted successfully',
    'record_not_found' => 'Record not found',
    'invalid_email' => 'Invalid email address',
    'invalid_password' => 'Invalid password',
    'passwords_dont_match' => 'Passwords do not match',
    'email_already_exists' => 'Email already exists',
    'unauthorized' => 'Unauthorized access',
    'page_not_found' => 'Page not found',

    // Roles
    'admin' => 'Administrator',
    'manager' => 'Manager',
    'controller' => 'Controller',
    'guard' => 'Guard',
    'client' => 'Client',

    // Profile Page
    'manage_profile' => 'View and manage your profile information',
    'profile_information' => 'Profile Information',
    'change_password' => 'Change Password',
    'security' => 'Security',
    'preferences' => 'Preferences',
    'current_password' => 'Current Password',
    'new_password' => 'New Password',
    'update_password' => 'Update Password',
    'password_requirements' => 'Minimum 8 characters with uppercase, lowercase, numbers and symbols',
    'email_cannot_be_changed' => 'Email address cannot be changed',
    'two_factor_authentication' => 'Two-Factor Authentication',
    '2fa_description' => 'Add an extra layer of security to your account',
    'enable_2fa' => 'Enable 2FA',
    '2fa_setup_required' => 'You will need an authenticator app',
    'save_changes' => 'Save Changes',
    'save_preferences' => 'Save Preferences',
    'notification_preferences' => 'Notification Preferences',
    'receive_email_notifications' => 'Receive email notifications',
    'receive_in_app_notifications' => 'Receive in-app notifications',
    'receive_sms_notifications' => 'Receive SMS notifications',

    // Staff/Users Management
    'manage_staff_members' => 'Manage team members and users',
    'add_user' => 'Add User',
    'add_first_user' => 'Add First User',
    'search_by_name_or_email' => 'Search by name or email',
    'all_roles' => 'All Roles',
    'all_statuses' => 'All Statuses',
    'last_login' => 'Last Login',
    'actions' => 'Actions',
    'edit_user' => 'Edit User',
    'add_new_user' => 'Add New User',
    'reset_password_for' => 'Reset password for',
    'yes_reset' => 'Yes, Reset Password',
    'password_reset' => 'Password has been reset',
    'deactivate' => 'Deactivate',
    'activate' => 'Activate',
    'yes_continue' => 'Yes, Continue',
    'delete_user' => 'Delete User',
    'delete_confirm_message' => 'This action cannot be undone. Are you sure you want to delete',
    'yes_delete' => 'Yes, Delete',
    'no_users_found' => 'No users found',
    'not_provided' => 'Not provided',
    'never' => 'Never',

    // Roles Management
    'roles' => 'Roles',
    'manage_user_roles' => 'Manage roles and permissions',
    'permissions' => 'Permissions',
    'no_permissions' => 'No permissions assigned',
    'permission_matrix' => 'Permission Matrix',
    'permission' => 'Permission',
    'create_new_role' => 'Create New Role',
    'add_custom_role' => 'Add a custom role for your organization',
    'role_name' => 'Role Name',
    'role_name_lowercase' => 'Role name must be lowercase without spaces',
    'description' => 'Description',
    'select_permissions' => 'Select Permissions',
    'create' => 'Create',
    'delete_role' => 'Delete Role',
    'delete_role_confirm' => 'Are you sure you want to delete this role? This cannot be undone.',
    'role_deleted' => 'Role has been deleted successfully',

    // Settings Page
    'general_settings' => 'General Settings',
    'appearance_settings' => 'Appearance Settings',
    'appearance' => 'Appearance',
    'notification_settings' => 'Notification Settings',
    'advanced_settings' => 'Advanced Settings',
    'advanced' => 'Advanced',
    'site_information' => 'Site Information',
    'email_address' => 'Email Address',
    'phone_number' => 'Phone Number',
    'logo' => 'Logo',
    'letterhead' => 'Letterhead',
    'upload_logo' => 'Upload Logo',
    'upload_letterhead' => 'Upload Letterhead',
    'color_picker' => 'Choose a color',
    'sms_gateway' => 'SMS Gateway',
    'sms_gateway_settings' => 'SMS Gateway Configuration',
    'sms_token' => 'SMS Gateway Token',
    'whatsapp_settings' => 'WhatsApp Settings',
    'whatsapp_token' => 'WhatsApp API Token',
    'enable_email' => 'Enable Email Notifications',
    'enable_sms' => 'Enable SMS Notifications',
    'enable_push' => 'Enable Push Notifications',
    'system_information' => 'System Information',
    'php_version' => 'PHP Version',
    'server' => 'Server',
    'current_time' => 'Current Time',
    'database_status' => 'Database Status',
    'backup_database' => 'Backup Database',
    'clear_cache' => 'Clear Cache',
    'cache_cleared' => 'Cache cleared successfully',
    'backup_created' => 'Backup created successfully',

    // Profile Photo Upload
    'profile_photo' => 'Profile Photo',
    'upload_photo' => 'Upload Photo',
    'change_photo' => 'Change Photo',
    'drag_drop_photo' => 'Drag and drop your photo here',
    'square_crop_recommended' => 'Square format recommended',
    'select_file' => 'Select File',
    'crop_photo' => 'Crop Photo',
    'photo_updated' => 'Photo has been updated successfully',
    'continue' => 'Continue',

    // Roles
    'admin' => 'Administrator',
    'manager' => 'Manager',
    'controller' => 'Controller',
    'guard' => 'Guard',
    'client' => 'Client',

    // Time
    'today' => 'Today',
    'yesterday' => 'Yesterday',
    'this_week' => 'This Week',
    'this_month' => 'This Month',
    'this_year' => 'This Year',

    // Auth Messages
    'error_invalid_credentials' => 'Invalid email or password',
    'error_email_exists' => 'This email is already registered',
    'error_password_mismatch' => 'Passwords do not match',
    'error_short_password' => 'Password must be at least 8 characters',
    'registration_successful' => 'Registration successful! Please check your email.',
    'redirecting' => 'Redirecting...',
    'have_account' => 'Already have an account?',
    'error_invalid_input' => 'Please check all fields',
    'full_name' => 'Full Name',
    'phone' => 'Phone',
    'address' => 'Address',
    'min_8_characters' => 'Minimum 8 characters',
    'sign_up' => 'Sign Up',
    'password_reset_success' => 'Password reset successfully',
    'join_us' => 'Join SSCI Office',
    'fast_setup' => 'Fast Setup',
    'get_started_quickly' => 'Get started in minutes',
    'secure' => 'Secure',
    'enterprise_grade' => 'Enterprise-grade security',
    'support' => '24/7 Support',
    'always_here' => 'Always here to help',
    'currency' => 'FCFA',
    'une' => 'A',
    
    // System Status
    'system_status' => 'System Status',
    'database' => 'Database',
    'online' => 'Online',
    'email_service' => 'Email Service',
    'sms_service' => 'SMS Service',
    'push_notifications' => 'Push Notifications',
    'enabled' => 'Enabled',
    'disabled' => 'Disabled',
    'quick_actions' => 'Quick Actions',
    'registered' => 'Registered',
    'view_all' => 'View All',
    'all_rights_reserved' => 'All rights reserved',
    'notifications' => 'Notifications',
    'mark_all_read' => 'Mark all as read',
    'version' => 'Version',
    'system_name' => 'SSCI Security Platform',
    'system_description' => 'Comprehensive security company management platform with client management, staff tracking, financial control, and performance evaluations',
    'quick_links' => 'Quick Links',
    'information' => 'Information',

        // Assessment Surface Area Categories
        'petite' => 'Small (<0.5ha)',
        'normale' => 'Normal (0.5-1ha)',
        'vaste' => 'Large (1-5ha)',
        'tres_vaste' => 'Very Large (>5ha)',

        // Assessment Access Points Categories
        'access_1_2' => '1-2 (Low)',
        'access_3_4' => '3-4 (Moderate)',
        'access_5' => '5 (High)',
        'access_5_plus' => '5+ (Critical)',

        // Assessment Buildings Categories
        'buildings_1' => '1 Unit (Low)',
        'buildings_2' => '2 Units (Moderate)',
        'buildings_3_plus' => '3+ Units (High)',

        // Assessment Content Value Categories
        'value_low' => '<2M FCFA (Low)',
        'value_moderate' => '2-10M FCFA (Moderate)',
        'value_high' => '10-50M FCFA (High)',
        'value_very_high' => '>50M FCFA (Very High)',

        // Risk Assessment Calculations
        'infrastructure_risk' => 'Infrastructure Risk',
        'zone_risk' => 'Zone Risk',
        'asset_risk' => 'Asset Risk',
        'low_risk' => 'Low Risk',
        'medium_risk' => 'Medium Risk',
        'high_risk' => 'High Risk',
        'critical_risk' => 'Critical Risk',
        
        // Settings - Database
        'database_settings' => 'Database Settings',
        'db_host' => 'Database Host',
        'db_port' => 'Database Port',
        'db_name' => 'Database Name',
        'db_user' => 'Database User',
        'db_password' => 'Database Password',
        'leave_blank_to_keep_current' => 'Leave blank to keep current password',
        
        // Settings - Email/SMTP
        'email_settings' => 'Email Settings',
        'enable_email' => 'Enable Email Notifications',
        'smtp_host' => 'SMTP Host',
        'smtp_port' => 'SMTP Port',
        'smtp_user' => 'SMTP Username',
        'smtp_password' => 'SMTP Password',
        'smtp_from' => 'From Email Address',
        'from_email' => 'From Email Address',
        
        // Settings - Application
        'app_settings' => 'Application Settings',
        'app_debug' => 'Enable Debug Mode',
        'enable_debug_mode' => 'Enable Debug Mode',
        'app_url' => 'Application URL',
        'app_key' => 'Application Key',
        'app_key_description' => 'This is a secret key used for encryption',
        'generate' => 'Generate',
        'key_generated' => 'Key generated successfully',
        
        // Settings - Notifications
        'sms_settings' => 'SMS Settings',
        'sms_gateway_token' => 'SMS Gateway Token',
        'whatsapp_settings' => 'WhatsApp Settings',
        'whatsapp_api_token' => 'WhatsApp API Token',
        'push_notifications' => 'Push Notifications',
        'enable_push_notifications' => 'Enable Push Notifications',
        
        // Settings - Messages
        'settings_updated_successfully' => 'Settings updated successfully',
        'profile_updated_successfully' => 'Profile updated successfully',
        'password_changed_successfully' => 'Password changed successfully',
        'preferences_updated_successfully' => 'Preferences updated successfully',
        'password_mismatch' => 'Password Mismatch',
        'passwords_do_not_match' => 'Passwords do not match',
        'saving' => 'Saving...',
        'updating' => 'Updating...',
        
        // User Management - Additional Labels
        'user_management' => 'User Management',
        'manage_users_and_roles' => 'Manage users, roles, and permissions',
        'manage_users' => 'Manage Users',
        'users' => 'Users',
        'no_users' => 'No users found',
        'error_loading_users' => 'Error loading users',
        'error_loading_user' => 'Error loading user details',
        'error_saving_user' => 'Error saving user',
        'error_deleting_user' => 'Error deleting user',
        'user_created' => 'User created successfully',
        'user_updated' => 'User updated successfully',
        'user_deleted' => 'User deleted successfully',
        'delete_user_confirm' => 'Are you sure you want to delete this user?',
        'name' => 'Name',
        'role' => 'Role',
        'phone' => 'Phone',
        'whatsapp' => 'WhatsApp',
        'address' => 'Address',
        'status' => 'Status',
        'created_at' => 'Created',
        'file_too_large' => 'File is too large',
        'invalid_file_type' => 'Invalid file type',
        'image_formats' => 'PNG, JPG, GIF up to 5MB',
        'crop_image' => 'Crop Image',
        'crop_and_save' => 'Crop & Save',
        'done' => 'Done',
        'no_permissions' => 'No permissions assigned',
        
        // Invoicing System
        'invoices' => 'Invoices',
        'manage_invoices_and_billing' => 'Manage invoices, billing, and payments',
        'all_invoices' => 'All Invoices',
        'generate_invoices' => 'Generate Invoices',
        'billing_settings' => 'Billing Settings',
        'new_invoice' => 'New Invoice',
        'invoice_number' => 'Invoice Number',
        'client' => 'Client',
        'post' => 'Post/Facility',
        'invoice_date' => 'Invoice Date',
        'due_date' => 'Due Date',
        'amount' => 'Amount',
        'status' => 'Status',
        'notes' => 'Notes',
        'print' => 'Print',
        'download_pdf' => 'Download PDF',
        'pay_now' => 'Pay Now',
        'error_loading_invoices' => 'Error loading invoices',
        'no_invoices' => 'No invoices found',
        'generate_monthly_invoices' => 'Generate Monthly Invoices',
        'billing_month' => 'Billing Month',
        'select_clients' => 'Select Clients to Bill',
        'invoice_generation_info' => 'Select the month and clients to automatically generate invoices based on their service contracts.',
        'schedule_auto_generate' => 'Schedule Auto-Generate',
        'billing_stats' => 'Billing Statistics',
        'auto_generate_tip' => 'Set up automatic invoice generation to run every month on a specific day and time.',
        'auto_generate_settings' => 'Auto-Generate Settings',
        'save_settings' => 'Save Settings',

        // Patrol System
        'manage_and_track_guard_patrols' => 'Manage and track guard patrols',
        'overview' => 'Overview',
        'dashboard' => 'Dashboard',
        'patrol_score' => 'Patrol Score',
        'patrol_points' => 'Patrol Points',
        'scans' => 'Scans',
        'patrol_settings' => 'Patrol Settings',
        'reminder_time' => 'Reminder Time',
        'minutes_before_hour_end' => 'minutes before hour end',
        'reminders_sent_at_minute' => 'Reminders sent at minute',
        'of_each_hour' => 'of each hour',
        'manage_patrol_for' => 'Managing patrol for',
        'manage_points' => 'Manage Points',
        'patrol_completed' => 'Completed',
        'patrol_incomplete' => 'Incomplete',
        'patrol_missed' => 'Missed',
        'next_patrol_hour' => 'Next Patrol Hour In',
        'start_scanner' => 'Start Scanner',
        'stop_scanner' => 'Stop Scanner',
        'scan_qr_code' => 'Scan QR Code',
        'last_scan_info' => 'Last Scan Information',
        'recent_scans' => 'Recent Scans',
        'patrol_history' => 'Patrol History',
        'patrol_time' => 'Patrol Time',
        'completion_percentage' => 'Completion %',
        'view_details' => 'View Details',
        'no_posts_available' => 'No posts available',
        'manage_patrol_points' => 'Manage Patrol Points',
        'add_patrol_point' => 'Add Patrol Point',
        'edit_patrol_point' => 'Edit Patrol Point',
        'delete_patrol_point' => 'Delete Patrol Point',
        'point_name' => 'Point Name',
        'qr_code' => 'QR Code',
        'point_status' => 'Point Status',
        'scan_count' => 'Scan Count',
        'complete' => 'Complete',

        // Feedback
        'feedbacks' => 'Feedbacks',
        'feedback' => 'Feedback',
        'add_feedback' => 'Add Feedback',
        'edit_feedback' => 'Edit Feedback',
        'delete_feedback' => 'Delete Feedback',
        'feedback_date' => 'Feedback Date',
        'feedback_subject' => 'Subject',
        'feedback_message' => 'Message',
        'feedback_rating' => 'Rating',
        'feedback_status' => 'Status',
        'feedback_type' => 'Feedback Type',
        'positive' => 'Positive',
        'negative' => 'Negative',
        'neutral' => 'Neutral',
        'create_feedback' => 'Create Feedback',
        'my_feedbacks' => 'My Feedbacks',
        'manage_points' => 'Manage Points',
        'activate' => 'Activate',
        'deactivate' => 'Deactivate',
        'select_post' => 'Select Post',
        'current_time' => 'Current Time',
        'this_hour' => 'This Hour',
        'today' => 'Today',
        'no_scans_yet' => 'No scans recorded yet',
        'contact_administrator' => 'Contact your administrator to add posts to your account',
    ];




