<?php
/**
 * Database Migration Runner
 */

require_once __DIR__ . '/../config/bootstrap.php';

$db = $GLOBALS['db'];
$migrationFile = $_GET['file'] ?? '007_create_pay_groups_table.sql';

try {
    // Read and execute the migration
    $sql = file_get_contents(__DIR__ . '/migrations/' . $migrationFile);
    
    // Split by semicolon and execute each statement
    $statements = array_filter(array_map('trim', explode(';', $sql)));
    
    foreach ($statements as $statement) {
        if (!empty($statement)) {
            $db->query($statement);
        }
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Migration completed successfully!'
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Migration failed: ' . $e->getMessage()
    ]);
}
?>

