<?php
/**
 * Role-Based Access Control Configuration
 * SSCI Office Platform
 */

return [
    'admin' => [
        'description' => 'Administrator with full access',
        'permissions' => ['*'],
        'pages' => ['dashboard', 'clients', 'staff', 'posts', 'finances', 'invoices', 'payments', 'salaries', 'controls', 'guards', 'patrols', 'messages', 'feedbacks', 'settings', 'evaluations', 'roles', 'reports','manage-points'],
    ],
    'manager' => [
        'description' => 'Manager with operational control',
        'permissions' => ['view_clients', 'view_staff', 'create_staff', 'edit_staff', 'delete_staff', 'view_posts', 'manage_guards', 'manage_patrols', 'view_finances', 'view_payments', 'view_salaries', 'view_controls', 'edit_controls', 'view_messages', 'edit_messages', 'manage_roles'],
        'pages' => ['dashboard', 'clients', 'staff', 'posts', 'finances', 'invoices', 'payments', 'salaries', 'controls', 'guards', 'patrols', 'messages', 'feedbacks', 'evaluations', 'reports'],
    ],
    'controller' => [
        'description' => 'Controller managing guards',
        'permissions' => ['view_posts', 'create_controls', 'edit_own_controls', 'view_guards', 'view_patrols', 'view_messages', 'edit_messages'],
        'pages' => ['controllers-dashboard', 'controllers-posts', 'controllers-patrols', 'controllers-controls', 'controllers-profile', 'controllers-payments', 'controllers-messages'],
    ],
    'guard' => [
        'description' => 'Security Guard',
        'permissions' => ['view_own_post', 'view_patrols', 'manage_patrols', 'view_messages'],
        'pages' => ['guards-dashboard', 'guards-posts', 'guards-patrols', 'guards-controls', 'guards-profile', 'guards-payments', 'guards-messages', 'guards-messages-gmail'],
    ],
    'client' => [
        'description' => 'Client/Service Recipient',
        'permissions' => ['view_own_posts', 'view_patrols', 'view_invoices', 'view_messages', 'create_payments', 'create_feedback', 'send_messages'],
        'pages' => ['dashboard', 'clients/dashboard', 'clients/profile', 'clients/my-posts', 'clients/contract', 'clients/site-assessment', 'clients/my-guards', 'clients/my-controls', 'clients/my-feedbacks', 'clients/my-patrols', 'clients/my-invoices', 'clients/payments', 'clients/feedbacks', 'clients/messages', 'clients-messages-gmail'],
    ],
];
