<?php
/**
 * Application Configuration
 * SSCI Office Platform
 */

// Calculate APP_URL with proper protocol detection
$appUrl = getenv('APP_URL') ?: 'http://localhost/ssci';

// Detect current protocol if running in web context
if (PHP_SAPI !== 'cli' && isset($_SERVER['HTTPS'])) {
    $protocol = ($_SERVER['HTTPS'] === 'on' || $_SERVER['HTTPS'] === '1') ? 'https' : 'http';
    
    // Extract domain from APP_URL
    $urlParts = parse_url($appUrl);
    $domain = $urlParts['host'] ?? $_SERVER['HTTP_HOST'] ?? 'localhost';
    $path = $urlParts['path'] ?? '';
    
    // Rebuild URL with detected protocol
    $appUrl = $protocol . '://' . $domain . $path;
}

$appUrl = rtrim($appUrl, '/');

return [
    'name' => 'SSCI Office',
    'acronym' => 'SSCI',
    'company' => 'Shepherd Security and Consultancy International',
    'debug' => getenv('APP_DEBUG') === 'true' ? true : (getenv('APP_DEBUG') ?: false),
    'timezone' => 'Africa/Douala',
    'url' => $appUrl,
    
    // Default Language
    'default_language' => 'en',
    'supported_languages' => ['en', 'fr'],
    
    // Currency Configuration
    'currency' => [
        'code' => getenv('CURRENCY_CODE') ?: 'FCFA',
        'symbol' => getenv('CURRENCY_SYMBOL') ?: 'FCFA',
        'decimal_places' => 2,
    ],
    
    // Pagination
    'pagination' => [
        'per_page' => 15,
    ],
    
    // Notifications
    'notifications' => [
        'email_enabled' => getenv('EMAIL_ENABLED') === 'true' ? true : false,
        'sms_enabled' => getenv('SMS_ENABLED') === 'true' ? true : false,
        'push_enabled' => getenv('PUSH_ENABLED') === 'true' ? true : false,
    ],
    
    // Services
    'services' => [
        'whatsapp_api_token' => getenv('WHATSAPP_API_TOKEN') ?: '',
        'sms_gateway_token' => getenv('SMS_GATEWAY_TOKEN') ?: '',
        'smtp_host' => getenv('SMTP_HOST') ?: '',
        'smtp_port' => getenv('SMTP_PORT') ?: 587,
        'smtp_user' => getenv('SMTP_USER') ?: '',
        'smtp_password' => getenv('SMTP_PASSWORD') ?: '',
        'smtp_from' => getenv('SMTP_FROM') ?: 'noreply@ssci.local',
    ],
    
    // UI Configuration
    'ui' => [
        'site_logo' => '/images/logo.png',
        'site_letterhead' => '/images/letterhead.png',
        'primary_color' => '#2563eb',
        'fonts' => [
            'primary' => 'PT Sans Narrow',
        ],
    ],
];
